/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.DualLoggerFactory;
import org.apache.sis.util.logging.LoggerFactory;

public final class Logging
extends Static {
    private static final int LEVEL_THRESHOLD_FOR_STACKTRACE = 600;
    private static volatile LoggerFactory<?> factory;

    private Logging() {
    }

    public static void setLoggerFactory(LoggerFactory<?> loggerFactory) {
        factory = loggerFactory;
    }

    public static LoggerFactory<?> getLoggerFactory() {
        return factory;
    }

    public static Logger getLogger(String string) {
        Logger logger;
        LoggerFactory<?> loggerFactory = factory;
        if (loggerFactory != null && (logger = loggerFactory.getLogger(string)) != null) {
            return logger;
        }
        return Logger.getLogger(string);
    }

    @Deprecated
    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        while ((clazz2 = clazz.getEnclosingClass()) != null) {
            clazz = clazz2;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = n >= 1 ? string.substring(0, n) : "";
        return Logging.getLogger(string);
    }

    public static void log(Class<?> clazz, String string, LogRecord logRecord) {
        Logger logger;
        logRecord.setSourceClassName(clazz.getCanonicalName());
        logRecord.setSourceMethodName(string);
        String string2 = logRecord.getLoggerName();
        if (string2 == null) {
            logger = Logging.getLogger(clazz);
            logRecord.setLoggerName(logger.getName());
        } else {
            logger = Logging.getLogger(string2);
        }
        logger.log(logRecord);
    }

    public static boolean unexpectedException(Logger logger, Throwable throwable) {
        return Logging.unexpectedException(logger, null, null, throwable, Level.WARNING);
    }

    public static boolean unexpectedException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.WARNING);
    }

    @Deprecated
    public static boolean unexpectedException(Class<?> clazz, String string, Throwable throwable) {
        return Logging.unexpectedException(null, clazz, string, throwable);
    }

    private static boolean unexpectedException(Logger logger, String string, String string2, Throwable throwable, Level level) {
        if (throwable == null) {
            return false;
        }
        if (logger == null && string != null) {
            int n = string.lastIndexOf(46);
            String object = n >= 1 ? string.substring(0, n - 1) : "";
            logger = Logging.getLogger(object);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        if (logger == null || string == null || string2 == null) {
            String string3 = logger != null ? logger.getName() : null;
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                char c;
                String string4 = stackTraceElement.getClassName();
                if (string != null) {
                    if (!string4.equals(string)) {
                        continue;
                    }
                } else if (string3 != null) {
                    if (!string4.startsWith(string3)) continue;
                    int n = string3.length();
                    if (string4.length() > n && Character.isJavaIdentifierPart(c = (char)string4.charAt(n))) continue;
                }
                String string5 = stackTraceElement.getMethodName();
                if (string2 != null && !string5.equals(string2)) continue;
                if (string3 == null && !(logger = Logging.getLogger(string3 = (c = string4.lastIndexOf(46)) >= '\u0001' ? string4.substring(0, c - '\u0001') : "")).isLoggable(level)) {
                    return false;
                }
                if (string == null) {
                    string = string4;
                }
                if (string2 != null) break;
                string2 = string5;
                break;
            }
            if (logger == null && !(logger = Logging.getLogger("global")).isLoggable(level)) {
                return false;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256).append(Classes.getShortClassName(throwable));
        String string6 = throwable.getMessage();
        if (string6 != null) {
            stringBuilder.append(": ").append(string6);
        }
        String string8 = stringBuilder.toString();
        string8 = Exceptions.formatChainedMessages(null, string8, throwable);
        LogRecord logRecord = new LogRecord(level, string8);
        if (string != null) {
            logRecord.setSourceClassName(string);
        }
        if (string2 != null) {
            logRecord.setSourceMethodName(string2);
        }
        if (level.intValue() >= 600) {
            logRecord.setThrown(throwable);
        }
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
        return true;
    }

    static boolean configurationException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.CONFIG);
    }

    @Deprecated
    public static boolean recoverableException(Class<?> clazz, String string, Throwable throwable) {
        return Logging.recoverableException(null, clazz, string, throwable);
    }

    public static boolean recoverableException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.FINE);
    }

    public static boolean severeException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.SEVERE);
    }

    static {
        LoggerFactory loggerFactory = null;
        for (LoggerFactory loggerFactory2 : ServiceLoader.load(LoggerFactory.class)) {
            if (loggerFactory == null) {
                loggerFactory = loggerFactory2;
                continue;
            }
            loggerFactory = new DualLoggerFactory(loggerFactory, loggerFactory2);
        }
        factory = loggerFactory;
    }
}

