/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.ldap.model.message.controls.ProxiedAuthz;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class ProxiedAuthzImpl
extends AbstractControl
implements ProxiedAuthz {
    private String authzId;

    public ProxiedAuthzImpl() {
        super("2.16.840.1.113730.3.4.18");
        this.setCritical(true);
    }

    @Override
    public String getAuthzId() {
        return this.authzId;
    }

    @Override
    public void setAuthzId(String authzId) {
        if (authzId == null) {
            throw new RuntimeException("Invalid proxied authz value : cannot be null");
        }
        if (!Strings.isEmpty((String)authzId)) {
            String lowercaseAuthzId = Strings.toLowerCaseAscii((String)authzId);
            if (lowercaseAuthzId.startsWith("dn:")) {
                String dn = authzId.substring(3);
                if (!Dn.isValid(dn)) {
                    throw new RuntimeException("Invalid proxied authz value : the DN is not valid");
                }
            } else if (!lowercaseAuthzId.startsWith("u:")) {
                throw new RuntimeException("Invalid proxied authz value : should start with 'dn:' or 'u:'");
            }
        }
        this.authzId = authzId;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        if (this.authzId != null) {
            h = h * 37 + this.authzId.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ProxiedAuthz otherControl = (ProxiedAuthz)o;
        return this.authzId == otherControl.getAuthzId() || this.authzId != null && this.authzId.equals(otherControl.getAuthzId());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Proxied Authz Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        authzid   : '").append(this.authzId).append("'\n");
        return sb.toString();
    }
}

