/*
 * Decompiled with CFR 0.152.
 */
package org.structr.autocomplete;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.structr.autocomplete.NonFunctionHint;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.function.Functions;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.dynamic.File;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.SchemaHelper;
import org.structr.schema.action.Function;
import org.structr.schema.action.Hint;
import org.structr.web.entity.User;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.Template;

public abstract class AbstractHintProvider {
    private static final Set<String> startChars = new HashSet<String>(Arrays.asList(".", ",", "(", "((", "(((", "((((", "(((((", "((((((", "${"));
    private static final Set<String> keywords = new HashSet<String>();
    public static final Property<String> displayText;
    public static final Property<String> text;
    public static final Property<GraphObject> from;
    public static final Property<GraphObject> to;
    public static final Property<Integer> line;
    public static final Property<Integer> ch;
    private final Comparator comparator = new HintComparator();

    protected abstract String getFunctionName(String var1);

    protected abstract boolean isJavascript();

    public List<GraphObject> getHints(GraphObject currentEntity, String type, String currentToken, String previousToken, String thirdToken, int cursorLine, int cursorPosition) {
        List<Hint> allHints = this.getAllHints(currentEntity, currentToken, previousToken, thirdToken);
        LinkedList<GraphObject> hints = new LinkedList<GraphObject>();
        int maxNameLength = 0;
        if (StringUtils.isBlank((String)currentToken) || startChars.contains(currentToken)) {
            for (Hint hint : allHints) {
                GraphObjectMap item = new GraphObjectMap();
                String functionName = this.getFunctionName(hint.getReplacement());
                if (hint.mayModify()) {
                    item.put(text, (Object)this.visitReplacement(functionName));
                } else {
                    item.put(text, (Object)functionName);
                }
                item.put(displayText, (Object)(this.getFunctionName(hint.getName()) + " - " + this.textOrPlaceholder(hint.shortDescription())));
                this.addPosition(item, hint, cursorLine, cursorPosition, cursorPosition);
                if (functionName.length() > maxNameLength) {
                    maxNameLength = functionName.length();
                }
                hints.add((GraphObject)item);
            }
        } else {
            int currentTokenLength = currentToken.length();
            for (Hint hint : allHints) {
                String functionName = this.getFunctionName(hint.getName());
                String replacement = hint.getReplacement();
                if (!functionName.startsWith(currentToken) && (currentToken.length() <= 2 || !functionName.contains(currentToken))) continue;
                GraphObjectMap item = new GraphObjectMap();
                if (hint.mayModify()) {
                    item.put(text, (Object)this.visitReplacement(replacement));
                } else {
                    item.put(text, (Object)replacement);
                }
                item.put(displayText, (Object)(this.getFunctionName(hint.getName()) + " - " + this.textOrPlaceholder(hint.shortDescription())));
                this.addPosition(item, hint, cursorLine, cursorPosition - currentTokenLength, cursorPosition);
                if (functionName.length() > maxNameLength) {
                    maxNameLength = functionName.length();
                }
                hints.add((GraphObject)item);
            }
        }
        this.alignHintDescriptions(hints, maxNameLength);
        return hints;
    }

    protected String visitReplacement(String replacement) {
        return replacement;
    }

    protected Hint createHint(String name, String signature, String description) {
        return this.createHint(name, signature, description, null);
    }

    protected Hint createHint(final String name, String signature, final String description, String replacement) {
        NonFunctionHint hint = new NonFunctionHint(){

            public String shortDescription() {
                return description;
            }

            public String getName() {
                return name;
            }
        };
        if (replacement != null) {
            hint.setReplacement(replacement);
        }
        return hint;
    }

    protected void alignHintDescriptions(List<GraphObject> hints, int maxNameLength) {
        for (GraphObject item : hints) {
            String text = (String)item.getProperty(displayText);
            int pos = text.indexOf(" - ");
            if (pos >= maxNameLength) continue;
            StringBuilder buf = new StringBuilder(text);
            buf.insert(pos, StringUtils.leftPad((String)"", (int)(maxNameLength - pos)));
            try {
                item.setProperty(displayText, (Object)buf.toString());
            }
            catch (FrameworkException frameworkException) {}
        }
    }

    protected String textOrPlaceholder(String source) {
        if (StringUtils.isBlank((String)source)) {
            return "   (no description available yet)";
        }
        return source;
    }

    protected List<Hint> getAllHints(GraphObject currentNode, String currentToken, String previousToken, String thirdToken) {
        boolean isDeclaration = this.isJavascript() && "var".equals(previousToken);
        boolean isAssignment = this.isJavascript() && "=".equals(previousToken);
        boolean isDotNotationRequest = ".".equals(currentToken);
        ConfigurationProvider config = StructrApp.getConfiguration();
        TreeMap<String, DataKey> dataKeys = new TreeMap<String, DataKey>();
        LinkedList<Hint> hints = new LinkedList<Hint>();
        LinkedList<Hint> local = new LinkedList<Hint>();
        Class currentObjectType = null;
        if (currentNode != null) {
            this.recursivelyFindDataKeys(currentNode, dataKeys);
        }
        switch (previousToken) {
            case "current": {
                currentObjectType = AbstractNode.class;
                break;
            }
            case "this": {
                currentObjectType = DOMNode.class;
                break;
            }
            case "me": {
                currentObjectType = User.class;
                break;
            }
            case "page": {
                currentObjectType = Page.class;
                break;
            }
            case "link": {
                currentObjectType = File.class;
                break;
            }
            case "template": {
                currentObjectType = Template.class;
                break;
            }
            case "parent": {
                currentObjectType = DOMElement.class;
                break;
            }
            default: {
                PropertyKey nestedKey;
                DataKey key = (DataKey)dataKeys.get(previousToken);
                if (key != null) {
                    currentObjectType = key.identifyType(config);
                    break;
                }
                if (!StringUtils.isNotBlank((String)thirdToken) || (key = (DataKey)dataKeys.get(thirdToken)) == null || (currentObjectType = key.identifyType(config)) == null || (nestedKey = config.getPropertyKeyForJSONName(currentObjectType, previousToken, false)) == null) break;
                currentObjectType = nestedKey.relatedType();
            }
        }
        if (!(keywords.contains(previousToken) || isDotNotationRequest || dataKeys.containsKey(previousToken))) {
            if (!isAssignment) {
                for (Function func : Functions.getFunctions()) {
                    hints.add((Hint)func);
                }
            }
            Collections.sort(hints, this.comparator);
            local.add(this.createHint("current", "", "Current data object", !this.isJavascript() ? null : "get('current')"));
            local.add(this.createHint("request", "", "Current request object", !this.isJavascript() ? null : "get('request')"));
            local.add(this.createHint("this", "", "Current object", !this.isJavascript() ? null : "get('this')"));
            local.add(this.createHint("element", "", "Current object", !this.isJavascript() ? null : "get('element')"));
            local.add(this.createHint("page", "", "Current page", !this.isJavascript() ? null : "get('page')"));
            local.add(this.createHint("link", "", "Current link", !this.isJavascript() ? null : "get('link')"));
            local.add(this.createHint("template", "", "Closest template node", !this.isJavascript() ? null : "get('template')"));
            local.add(this.createHint("parent", "", "Parent node", !this.isJavascript() ? null : "get('parent')"));
            local.add(this.createHint("children", "", "Collection of child nodes", !this.isJavascript() ? null : "get('children')"));
            local.add(this.createHint("host", "", "Client's host name", !this.isJavascript() ? null : "get('host')"));
            local.add(this.createHint("port", "", "Client's port", !this.isJavascript() ? null : "get('port')"));
            local.add(this.createHint("path_info", "", "URL path", !this.isJavascript() ? null : "get('path_info')"));
            local.add(this.createHint("now", "", "Current date", !this.isJavascript() ? null : "get('now')"));
            local.add(this.createHint("me", "", "Current user", !this.isJavascript() ? null : "get('me)"));
            local.add(this.createHint("locale", "", "Current locale", !this.isJavascript() ? null : "get('locale')"));
        }
        Collections.sort(local, this.comparator);
        hints.addAll(0, local);
        if (currentObjectType == null && !dataKeys.containsKey(previousToken) && !isDotNotationRequest || isAssignment) {
            for (DataKey dataKey : dataKeys.values()) {
                String replacement = this.isJavascript() && !isDeclaration ? "get('" + dataKey.getDataKey() + "')" : null;
                Hint dataKeyHint = this.createHint(dataKey.getDataKey(), "", dataKey.getDescription(), replacement);
                dataKeyHint.allowNameModification(!isDeclaration);
                hints.add(0, dataKeyHint);
            }
        }
        this.collectHintsForType(hints, config, currentObjectType);
        return hints;
    }

    private void addPosition(GraphObjectMap item, Hint hint, int cursorLine, int replaceFrom, int replaceTo) {
        GraphObjectMap fromObject = new GraphObjectMap();
        GraphObjectMap toObject = new GraphObjectMap();
        fromObject.put(line, (Object)cursorLine);
        fromObject.put(ch, (Object)replaceFrom);
        toObject.put(line, (Object)cursorLine);
        toObject.put(ch, (Object)replaceTo);
        item.put(from, (Object)fromObject);
        item.put(to, (Object)toObject);
    }

    private void recursivelyFindDataKeys(GraphObject entity, Map<String, DataKey> dataKeys) {
        if (entity != null) {
            String dataKey = (String)entity.getProperty(DOMNode.dataKey);
            if (dataKey != null) {
                DataKey key = new DataKey(entity);
                dataKeys.put(key.getDataKey(), key);
            }
            this.recursivelyFindDataKeys((GraphObject)entity.getProperty(DOMNode.parent), dataKeys);
        }
    }

    private void collectHintsForType(List<Hint> hints, ConfigurationProvider config, Class type) {
        if (type != null) {
            LinkedList<Hint> propertyHints = new LinkedList<Hint>();
            for (PropertyKey propertyKey : config.getPropertySet(type, "all")) {
                String keyName = propertyKey.jsonName();
                if (keyName.startsWith("_html_") || keyName.startsWith("data-structr-")) continue;
                Hint propertyHint = this.createHint(keyName, "", type.getSimpleName() + " property");
                propertyHint.setIsDynamic(propertyKey.isDynamic());
                propertyHint.allowNameModification(false);
                propertyHints.add(propertyHint);
            }
            Collections.sort(propertyHints, this.comparator);
            hints.addAll(0, propertyHints);
        }
    }

    static {
        keywords.add("current");
        keywords.add("request");
        keywords.add("this");
        keywords.add("element");
        keywords.add("page");
        keywords.add("link");
        keywords.add("template");
        keywords.add("parent");
        keywords.add("children");
        keywords.add("host");
        keywords.add("port");
        keywords.add("path_info");
        keywords.add("now");
        keywords.add("me");
        keywords.add("locale");
        displayText = new StringProperty("displayText");
        text = new StringProperty("text");
        from = new GenericProperty("from");
        to = new GenericProperty("to");
        line = new IntProperty("line");
        ch = new IntProperty("ch");
    }

    private static class DataKey
    implements Comparable<DataKey> {
        private QueryType queryType = QueryType.REST;
        private String dataKey = null;
        private String query = null;

        public DataKey(GraphObject entity) {
            this.dataKey = (String)entity.getProperty(DOMNode.dataKey);
            this.query = (String)entity.getProperty(DOMNode.restQuery);
            if (this.query == null) {
                this.query = (String)entity.getProperty(DOMNode.cypherQuery);
                this.queryType = QueryType.Cypher;
            }
            if (this.query == null) {
                this.query = (String)entity.getProperty(DOMNode.xpathQuery);
                this.queryType = QueryType.XPath;
            }
            if (this.query == null) {
                this.query = (String)entity.getProperty(DOMNode.functionQuery);
                this.queryType = QueryType.Function;
            }
        }

        public String getDataKey() {
            return this.dataKey;
        }

        public String getDescription() {
            StringBuilder buf = new StringBuilder();
            buf.append("Data key for ");
            buf.append((Object)this.queryType);
            buf.append(" query ");
            buf.append(StringUtils.abbreviate((String)this.query, (int)20));
            return buf.toString();
        }

        @Override
        public int compareTo(DataKey other) {
            return this.dataKey.compareTo(other.getDataKey());
        }

        public Class identifyType(ConfigurationProvider config) {
            switch (this.queryType) {
                case REST: {
                    return this.identifyRestQueryType();
                }
                case Cypher: {
                    break;
                }
                case XPath: {
                    return DOMNode.class;
                }
            }
            return null;
        }

        private Class identifyRestQueryType() {
            int queryStart;
            String cleanedQuery = this.query.replaceAll("\\$\\{.*\\}", "");
            if (cleanedQuery.startsWith("/")) {
                cleanedQuery = cleanedQuery.substring(1);
            }
            if ((queryStart = cleanedQuery.indexOf("?")) >= 0 && queryStart < cleanedQuery.length()) {
                cleanedQuery = cleanedQuery.substring(0, queryStart);
            }
            return SchemaHelper.getEntityClassForRawType((String)cleanedQuery);
        }
    }

    protected static class HintComparator
    implements Comparator<Hint> {
        protected HintComparator() {
        }

        @Override
        public int compare(Hint o1, Hint o2) {
            boolean firstIsDynamic = o1.isDynamic();
            boolean secindIsDynamic = o2.isDynamic();
            if (firstIsDynamic && !secindIsDynamic) {
                return -1;
            }
            if (!firstIsDynamic && secindIsDynamic) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static enum QueryType {
        REST,
        Cypher,
        XPath,
        Function;

    }
}

