/*
 * Decompiled with CFR 0.152.
 */
package org.structr.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.structr.autocomplete.AbstractHintProvider;
import org.structr.core.GraphObject;

public class PlaintextHintProvider
extends AbstractHintProvider {
    @Override
    protected String getFunctionName(String sourceName) {
        return sourceName;
    }

    @Override
    public List<GraphObject> getHints(GraphObject currentEntity, String type, String mainToken, String secondaryToken, String otherToken, int line, int cursorPosition) {
        List<String> tokens = this.parseTokens(mainToken, cursorPosition);
        String currentToken = this.getTokenOrBlank(tokens, 0);
        String previousToken = this.getTokenOrBlank(tokens, 1);
        String thirdToken = this.getTokenOrBlank(tokens, 2);
        return super.getHints(currentEntity, type, currentToken, previousToken, thirdToken, line, cursorPosition);
    }

    private List<String> parseTokens(String source, int cursorPosition) {
        int length = cursorPosition != -1 && cursorPosition < source.length() ? cursorPosition : source.length();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean currentIsLetter = false;
        boolean lastWasLetter = false;
        for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            lastWasLetter = currentIsLetter;
            boolean bl = currentIsLetter = Character.isDigit(c) || Character.isLetter(c) || c == '_';
            if (lastWasLetter != currentIsLetter) {
                tokens.add(buf.toString().trim());
                buf.setLength(0);
            }
            buf.append(c);
        }
        tokens.add(buf.toString().trim());
        int len = tokens.size();
        for (int i = 1; i < len; ++i) {
            String token = (String)tokens.get(i);
            String before = (String)tokens.get(i - 1);
            if (i + 1 >= len) continue;
            String after = (String)tokens.get(i + 1);
            if (!".".equals(token) || ".".equals(before) || ".".equals(after)) continue;
            tokens.remove(i);
            --len;
        }
        return tokens;
    }

    @Override
    protected boolean isJavascript() {
        return false;
    }

    private String getTokenOrBlank(List<String> tokens, int reverseIndex) {
        int length = tokens.size();
        int index = length - reverseIndex - 1;
        if (index >= 0 && length > 0 && index < length) {
            return tokens.get(index);
        }
        return "";
    }
}

