/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.rest;

import java.io.IOException;
import org.codehaus.plexus.util.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.console.rest.RestCommand;
import org.structr.util.Writable;

public class AuthRestCommand
extends RestCommand {
    protected String username = null;
    protected String password = null;

    @Override
    public void run(Console console, Writable writable) throws FrameworkException, IOException {
        console.setUsername(this.username);
        console.setPassword(this.password);
    }

    @Override
    public boolean parseNext(String line, Writable writable) throws IOException {
        if (StringUtils.isNotBlank((String)line)) {
            String[] parts = line.split("[\\s]+");
            if (parts.length == 2) {
                this.username = parts[0];
                this.password = parts[1];
            }
        } else {
            this.username = null;
            this.password = null;
        }
        return true;
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Sets authentication information for subsequent requests."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"auth <username> <password> - Sets authentication information for subsequent requests. Run without parameters to reset credentials."});
    }

    static {
        RestCommand.registerCommand("auth", AuthRestCommand.class);
    }
}

