/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.rest;

import com.jayway.restassured.response.Response;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.console.rest.RestCommand;
import org.structr.util.Writable;

public class DeleteRestCommand
extends RestCommand {
    private String uri = null;

    @Override
    public void run(Console console, Writable writable) throws FrameworkException, IOException {
        String requestUrl = this.getBaseUrl() + this.getBasePath() + this.uri;
        Response response = (Response)this.request(console).delete(requestUrl, new Object[0]);
        writable.println(new Object[]{"DELETE ", requestUrl});
        writable.println(new Object[]{response.getStatusLine()});
        writable.print(new Object[]{response.asString()});
    }

    @Override
    public boolean parseNext(String line, Writable writable) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)line)) {
            this.uri = line;
            return true;
        }
        writable.println(new Object[]{"Syntax error, missing URI parameter."});
        return false;
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Executes a REST DELETE request."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"delete <URI> - Executes the given DELETE request."});
    }

    static {
        RestCommand.registerCommand("delete", DeleteRestCommand.class);
        RestCommand.registerCommand("del", DeleteRestCommand.class);
    }
}

