/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.util.Writable;

public abstract class RestCommand {
    private static final Map<String, Class<? extends RestCommand>> commands = new TreeMap<String, Class<? extends RestCommand>>();
    private String username = null;
    private String password = null;

    public abstract void run(Console var1, Writable var2) throws FrameworkException, IOException;

    public abstract boolean parseNext(String var1, Writable var2) throws IOException;

    public abstract void commandHelp(Writable var1) throws IOException;

    public abstract void detailHelp(Writable var1) throws IOException;

    protected void authenticate(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected RequestSpecification request(Console console) {
        RequestSpecification req = RestAssured.given();
        String usernameFromAuth = console.getUsername();
        String passwordFromAuth = console.getPassword();
        req.accept(ContentType.JSON);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.username, this.password})) {
            req.header("X-User", (Object)this.username, new Object[0]);
            req.header("X-Password", (Object)this.password, new Object[0]);
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{usernameFromAuth, passwordFromAuth})) {
            req.header("X-User", (Object)usernameFromAuth, new Object[0]);
            req.header("X-Password", (Object)passwordFromAuth, new Object[0]);
        }
        return req;
    }

    protected String getBaseUrl() {
        StringBuilder buf = new StringBuilder("http://");
        buf.append((String)Settings.ApplicationHost.getValue());
        buf.append(":");
        buf.append(Settings.HttpPort.getValue());
        return buf.toString();
    }

    protected String getBasePath() {
        return StringUtils.removeEnd((String)((String)Settings.RestServletPath.getValue()), (String)"/*");
    }

    public static Set<String> commandNames() {
        return commands.keySet();
    }

    public static void registerCommand(String name, Class<? extends RestCommand> cmd) {
        commands.put(name, cmd);
    }

    public static void run(Console console, String line, Writable writable) throws FrameworkException, IOException {
        RestCommand cmd = RestCommand.parse(line, writable);
        if (cmd != null) {
            cmd.run(console, writable);
        }
    }

    public static RestCommand parse(String line, Writable writable) throws IOException {
        String trimmed = line.trim();
        String firstWord = StringUtils.substringBefore((String)trimmed, (String)" ");
        String remaining = StringUtils.substringAfter((String)trimmed, (String)" ");
        if (StringUtils.isNotBlank((CharSequence)firstWord)) {
            RestCommand cmd = RestCommand.getCommand(firstWord);
            if (cmd != null) {
                if (StringUtils.isBlank((CharSequence)remaining) || cmd.parseNext(remaining, writable)) {
                    return cmd;
                }
            } else {
                writable.println(new Object[]{"Unknown command '" + firstWord + "'."});
            }
        }
        return null;
    }

    public static RestCommand getCommand(String name) {
        Class<? extends RestCommand> cls = commands.get(name);
        if (cls != null) {
            try {
                return cls.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

