/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.tabcompletion;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.console.tabcompletion.TabCompletionProvider;
import org.structr.console.tabcompletion.TabCompletionResult;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;

public abstract class AbstractTabCompletionProvider
implements TabCompletionProvider {
    protected List<TabCompletionResult> getTabCompletionForUUIDs(SecurityContext securityContext, String token, String suffix) {
        LinkedList<TabCompletionResult> results = new LinkedList<TabCompletionResult>();
        if (token.length() >= 3) {
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            try (Tx tx = app.tx();){
                for (GraphObject obj : app.cypher("MATCH (n) WHERE n.id STARTS WITH {part} RETURN n", this.toMap("part", token))) {
                    results.add(this.getCompletion(obj.getUuid(), token, suffix));
                }
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                // empty catch block
            }
        }
        return results;
    }

    protected List<TabCompletionResult> getCaseInsensitiveResultsForCollection(Collection<String> words, String token, String suffix) {
        LinkedList<TabCompletionResult> result = new LinkedList<TabCompletionResult>();
        String lowerToken = token.toLowerCase();
        boolean upperCase = StringUtils.isAllUpperCase((CharSequence)token);
        for (String word : words) {
            if (!word.startsWith(lowerToken)) continue;
            if (upperCase) {
                result.add(this.getCompletion(word.toUpperCase(), token));
                continue;
            }
            result.add(this.getCompletion(word, token));
        }
        return result;
    }

    protected List<TabCompletionResult> getExactResultsForCollection(Collection<String> words, String token, String suffix) {
        LinkedList<TabCompletionResult> result = new LinkedList<TabCompletionResult>();
        for (String word : words) {
            if (!word.startsWith(token)) continue;
            result.add(this.getCompletion(word, token, suffix));
        }
        return result;
    }

    protected TabCompletionResult getCompletion(String command, String token) {
        return this.getCompletion(command, token, " ");
    }

    protected TabCompletionResult getCompletion(String command, String token, String suffix) {
        return new TabCompletionResult(command, command.substring(token.length()), suffix);
    }

    protected String getToken(String line, String separators) {
        String[] parts = StringUtils.splitPreserveAllTokens((String)line, (String)separators);
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return "";
    }

    protected Map<String, Object> toMap(String key, Object value) {
        return this.toMap(new HashMap<String, Object>(), key, value);
    }

    protected Map<String, Object> toMap(Map<String, Object> map, String key, Object value) {
        Map<String, Object> thisMap = map;
        if (thisMap == null) {
            thisMap = new HashMap<String, Object>();
        }
        if (key != null && value != null) {
            thisMap.put(key, value);
        }
        return thisMap;
    }
}

