/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis;

import java.io.File;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.server.TempStoreOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.exception.AuthenticationException;
import org.structr.core.entity.Principal;
import org.structr.core.entity.SuperUser;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.cmis.StructrCMISService;
import org.structr.rest.auth.AuthHelper;

public class StructrCMISServicesFactory
implements CmisServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)CmisServiceFactory.class.getName());

    public void init(Map<String, String> config) {
        logger.info("Initialization map: {}", config);
    }

    public void destroy() {
    }

    public CmisService getService(CallContext cc) {
        return new StructrCMISService(this.checkAuthentication(cc));
    }

    public File getTempDirectory() {
        return new File("/tmp");
    }

    public boolean encryptTempFiles() {
        return false;
    }

    public int getMemoryThreshold() {
        return 0x1400000;
    }

    public long getMaxContentSize() {
        return 0x40000000L;
    }

    public TempStoreOutputStream getTempFileOutputStream(String string) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityContext checkAuthentication(CallContext callContext) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            String username = callContext.getUsername();
            String password = callContext.getPassword();
            Principal principal = AuthHelper.getPrincipalForPassword((PropertyKey)Principal.name, (String)username, (String)password);
            SecurityContext securityContext2 = null;
            if (principal != null) {
                securityContext2 = principal instanceof SuperUser ? SecurityContext.getSuperUserInstance() : SecurityContext.getInstance((Principal)principal, (AccessMode)AccessMode.Backend);
            }
            tx.success();
            if (securityContext2 == null) throw new CmisUnauthorizedException();
            SecurityContext securityContext = securityContext2;
            return securityContext;
        }
        catch (AuthenticationException aex) {
            throw new CmisUnauthorizedException(aex.getMessage());
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        throw new CmisUnauthorizedException();
    }
}

