/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.ExtensionFeature;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cmis.common.CMISExtensionsData;
import org.structr.common.Permission;
import org.structr.files.cmis.config.StructrRepositoryCapabilities;
import org.structr.files.cmis.repository.StructrAccessControlPermissionMapping;
import org.structr.files.cmis.repository.StructrDeletePermissionMapping;
import org.structr.files.cmis.repository.StructrPermissionDefinition;
import org.structr.files.cmis.repository.StructrReadPermissionMapping;
import org.structr.files.cmis.repository.StructrWritePermissionMapping;

public class StructrRepositoryInfo
extends CMISExtensionsData
implements RepositoryInfo,
AclCapabilities {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrRepositoryInfo.class.getName());

    public String getId() {
        return "default";
    }

    public String getName() {
        return "Structr CMIS Repository";
    }

    public String getDescription() {
        return this.getName();
    }

    public String getVendorName() {
        return "Structr";
    }

    public String getProductName() {
        return "Structr CMIS";
    }

    public String getProductVersion() {
        return "1.1";
    }

    public String getRootFolderId() {
        return "/";
    }

    public RepositoryCapabilities getCapabilities() {
        return new StructrRepositoryCapabilities();
    }

    public AclCapabilities getAclCapabilities() {
        return this;
    }

    public String getLatestChangeLogToken() {
        return null;
    }

    public String getCmisVersionSupported() {
        return "1.1";
    }

    public CmisVersion getCmisVersion() {
        return CmisVersion.CMIS_1_1;
    }

    public String getThinClientUri() {
        return "http://localhost:8082/structr/";
    }

    public Boolean getChangesIncomplete() {
        return false;
    }

    public List<BaseTypeId> getChangesOnType() {
        return Collections.emptyList();
    }

    public String getPrincipalIdAnonymous() {
        return "anonymous";
    }

    public String getPrincipalIdAnyone() {
        return "anyone";
    }

    public List<ExtensionFeature> getExtensionFeatures() {
        return Collections.emptyList();
    }

    public SupportedPermissions getSupportedPermissions() {
        return SupportedPermissions.REPOSITORY;
    }

    public AclPropagation getAclPropagation() {
        return AclPropagation.OBJECTONLY;
    }

    public List<PermissionDefinition> getPermissions() {
        LinkedList<PermissionDefinition> permissions = new LinkedList<PermissionDefinition>();
        permissions.add(new StructrPermissionDefinition(Permission.read, "Read access"));
        permissions.add(new StructrPermissionDefinition(Permission.write, "Write access"));
        permissions.add(new StructrPermissionDefinition(Permission.delete, "Write access"));
        permissions.add(new StructrPermissionDefinition(Permission.accessControl, "Access control"));
        return permissions;
    }

    public Map<String, PermissionMapping> getPermissionMapping() {
        LinkedHashMap<String, PermissionMapping> mapping = new LinkedHashMap<String, PermissionMapping>();
        mapping.put(Permission.read.name(), new StructrReadPermissionMapping());
        mapping.put(Permission.write.name(), new StructrWritePermissionMapping());
        mapping.put(Permission.delete.name(), new StructrDeletePermissionMapping());
        mapping.put(Permission.accessControl.name(), new StructrAccessControlPermissionMapping());
        return mapping;
    }
}

