/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis.wrapper;

import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.structr.cmis.common.CMISExtensionsData;

public class CMISPagingListWrapper<T>
extends CMISExtensionsData {
    private List<T> list = null;
    private int maxItems = Integer.MAX_VALUE;
    private int skipCount = 0;

    public CMISPagingListWrapper() {
        this(new LinkedList(), null, null);
    }

    public CMISPagingListWrapper(List<T> list) {
        this(list, null, null);
    }

    public CMISPagingListWrapper(BigInteger maxItems, BigInteger skipCount) {
        this(new LinkedList(), maxItems, skipCount);
    }

    public CMISPagingListWrapper(List<T> list, BigInteger maxItems, BigInteger skipCount) {
        this.list = list;
        if (maxItems != null) {
            this.maxItems = maxItems.intValue();
        }
        if (skipCount != null) {
            this.skipCount = skipCount.intValue();
        }
    }

    public void setList(List<T> data) {
        this.list = data;
    }

    public void add(T data) {
        this.list.add(data);
    }

    public void addAll(Collection<T> data) {
        this.list.addAll(data);
    }

    public Boolean hasMoreItems() {
        return this.list.size() > this.skipCount + this.maxItems;
    }

    public BigInteger getNumItems() {
        return BigInteger.valueOf(this.list.size());
    }

    public List<T> getRawList() {
        return this.list;
    }

    public List<T> getPagedList() {
        int size = this.list.size();
        int to = Math.min(this.maxItems, size);
        int from = 0;
        from = Math.min(this.skipCount, size);
        to = Math.min(to + this.skipCount, size);
        return this.list.subList(from, to);
    }
}

