/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.auth;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.core.property.PropertyKey;
import org.structr.web.auth.StructrOAuthClient;
import org.structr.web.entity.User;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterAuthClient
extends StructrOAuthClient {
    private static final Logger logger = LoggerFactory.getLogger((String)TwitterAuthClient.class.getName());
    private static Twitter twitter;

    @Override
    protected void init(String authorizationLocation, String tokenLocation, String clientId, String clientSecret, String redirectUri, Class tokenResponseClass) {
        super.init(authorizationLocation, tokenLocation, clientId, clientSecret, redirectUri, tokenResponseClass);
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setOAuthAuthorizationURL(authorizationLocation);
        cb.setOAuthAccessTokenURL(tokenLocation);
        Configuration conf = cb.build();
        TwitterFactory tf = new TwitterFactory(conf);
        twitter = tf.getInstance();
        twitter.setOAuthConsumer(clientId, clientSecret);
    }

    @Override
    public String getEndUserAuthorizationRequestUri(HttpServletRequest request) {
        try {
            RequestToken requestToken = twitter.getOAuthRequestToken();
            request.getSession().setAttribute("requestToken", (Object)requestToken);
            String authorizationUrl = twitter.getConfiguration().getOAuthAuthorizationURL().concat("?oauth_token=").concat(requestToken.getToken());
            logger.info("Authorization request location URI: {}", (Object)authorizationUrl);
            return authorizationUrl;
        }
        catch (TwitterException ex) {
            logger.error("", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getAccessToken(HttpServletRequest request) {
        String verifier = request.getParameter("oauth_verifier");
        RequestToken requestToken = (RequestToken)request.getSession().getAttribute("requestToken");
        try {
            AccessToken accessToken = twitter.getOAuthAccessToken(requestToken, verifier);
            return accessToken.toString();
        }
        catch (TwitterException ex) {
            logger.error("", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getValue(HttpServletRequest request, String key) {
        try {
            return twitter.getScreenName();
        }
        catch (IllegalStateException | TwitterException ex) {
            logger.error("", ex);
            return null;
        }
    }

    @Override
    public StructrOAuthClient.ResponseFormat getResponseFormat() {
        return StructrOAuthClient.ResponseFormat.json;
    }

    @Override
    public String getReturnUri() {
        return (String)Settings.OAuthTwitterReturnUri.getValue();
    }

    @Override
    public String getErrorUri() {
        return (String)Settings.OAuthTwitterErrorUri.getValue();
    }

    @Override
    public PropertyKey getCredentialKey() {
        return User.twitterName;
    }

    @Override
    public String getCredential(HttpServletRequest request) {
        return this.getValue(request, "screen_name");
    }
}

