/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.auth;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.AccessMode;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Services;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.auth.exception.AuthenticationException;
import org.structr.core.auth.exception.UnauthorizedException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.entity.ResourceAccess;
import org.structr.core.entity.SuperUser;
import org.structr.core.property.PropertyKey;
import org.structr.rest.auth.AuthHelper;
import org.structr.rest.auth.SessionHelper;
import org.structr.web.auth.StructrOAuthClient;
import org.structr.web.entity.User;
import org.structr.web.resource.RegistrationResource;
import org.structr.web.servlet.HtmlServlet;

public class UiAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger((String)UiAuthenticator.class.getName());
    protected boolean examined = false;
    private static final Map<String, Method> methods = new LinkedHashMap<String, Method>();
    public static final long FORBIDDEN = 0L;
    public static final long AUTH_USER_GET = 1L;
    public static final long AUTH_USER_PUT = 2L;
    public static final long AUTH_USER_POST = 4L;
    public static final long AUTH_USER_DELETE = 8L;
    public static final long NON_AUTH_USER_GET = 16L;
    public static final long NON_AUTH_USER_PUT = 32L;
    public static final long NON_AUTH_USER_POST = 64L;
    public static final long NON_AUTH_USER_DELETE = 128L;
    public static final long AUTH_USER_OPTIONS = 256L;
    public static final long NON_AUTH_USER_OPTIONS = 512L;
    public static final long AUTH_USER_HEAD = 1024L;
    public static final long NON_AUTH_USER_HEAD = 2048L;

    public SecurityContext initializeAndExamineRequest(HttpServletRequest request, HttpServletResponse response) throws FrameworkException {
        Principal user = SessionHelper.checkSessionAuthentication((HttpServletRequest)request);
        if (user == null) {
            user = this.checkExternalAuthentication(request, response);
        }
        if (user == null) {
            user = this.getUser(request, true);
        }
        SecurityContext securityContext = user == null ? SecurityContext.getInstance((Principal)user, (HttpServletRequest)request, (AccessMode)AccessMode.Frontend) : (user instanceof SuperUser ? SecurityContext.getSuperUserInstance((HttpServletRequest)request) : SecurityContext.getInstance((Principal)user, (HttpServletRequest)request, (AccessMode)AccessMode.Backend));
        securityContext.setAuthenticator((Authenticator)this);
        String origin = request.getHeader("Origin");
        if (!StringUtils.isBlank((CharSequence)origin)) {
            String exposeHeaders;
            String allowCredentials;
            String allowHeaders;
            String allowMethods;
            response.setHeader("Access-Control-Allow-Origin", origin);
            String maxAge = (String)Settings.AccessControlMaxAge.getValue();
            if (StringUtils.isNotBlank((CharSequence)maxAge)) {
                response.setHeader("Access-Control-MaxAge", maxAge);
            }
            if (StringUtils.isNotBlank((CharSequence)(allowMethods = (String)Settings.AccessControlAllowMethods.getValue()))) {
                response.setHeader("Access-Control-Allow-Methods", allowMethods);
            }
            if (StringUtils.isNotBlank((CharSequence)(allowHeaders = (String)Settings.AccessControlAllowHeaders.getValue()))) {
                response.setHeader("Access-Control-Allow-Headers", allowHeaders);
            }
            if (StringUtils.isNotBlank((CharSequence)(allowCredentials = (String)Settings.AccessControlAllowCredentials.getValue()))) {
                response.setHeader("Access-Control-Allow-Credentials", allowCredentials);
            }
            if (StringUtils.isNotBlank((CharSequence)(exposeHeaders = (String)Settings.AccessControlExposeHeaders.getValue()))) {
                response.setHeader("Access-Control-Expose-Headers", exposeHeaders);
            }
        }
        this.examined = true;
        securityContext.setResponse(response);
        response.setHeader("X-Structr-Edition", Services.getInstance().getEdition());
        return securityContext;
    }

    public boolean hasExaminedRequest() {
        return this.examined;
    }

    public void checkResourceAccess(SecurityContext securityContext, HttpServletRequest request, String rawResourceSignature, String propertyView) throws FrameworkException {
        boolean validUser;
        ResourceAccess resourceAccess = ResourceAccess.findGrant((SecurityContext)securityContext, (String)rawResourceSignature);
        Method method = methods.get(request.getMethod());
        Principal user = securityContext.getUser(false);
        boolean bl = validUser = user != null;
        if (validUser && (user instanceof SuperUser || ((Boolean)user.getProperty((PropertyKey)Principal.isAdmin)).booleanValue())) {
            return;
        }
        if (resourceAccess == null) {
            logger.info("No resource access grant found for signature {}. (URI: {})", new Object[]{rawResourceSignature, securityContext.getCompoundRequestURI()});
            throw new UnauthorizedException("Forbidden");
        }
        switch (method) {
            case GET: {
                if (!validUser && resourceAccess.hasFlag(16L)) {
                    return;
                }
                if (!validUser || !resourceAccess.hasFlag(1L)) break;
                return;
            }
            case PUT: {
                if (!validUser && resourceAccess.hasFlag(32L)) {
                    return;
                }
                if (!validUser || !resourceAccess.hasFlag(2L)) break;
                return;
            }
            case POST: {
                if (!validUser && resourceAccess.hasFlag(64L)) {
                    return;
                }
                if (!validUser || !resourceAccess.hasFlag(4L)) break;
                return;
            }
            case DELETE: {
                if (!validUser && resourceAccess.hasFlag(128L)) {
                    return;
                }
                if (!validUser || !resourceAccess.hasFlag(8L)) break;
                return;
            }
            case OPTIONS: {
                if (!validUser && resourceAccess.hasFlag(512L)) {
                    return;
                }
                if (!validUser || !resourceAccess.hasFlag(256L)) break;
                return;
            }
            case HEAD: {
                if (!validUser && resourceAccess.hasFlag(2048L)) {
                    return;
                }
                if (!validUser || !resourceAccess.hasFlag(1024L)) break;
                return;
            }
        }
        logger.info("Resource access grant found for signature {}, but method {} not allowed for {}.", new Object[]{rawResourceSignature, method, validUser ? "authenticated users" : "public users"});
        throw new UnauthorizedException("Forbidden");
    }

    public Principal doLogin(HttpServletRequest request, String emailOrUsername, String password) throws AuthenticationException, FrameworkException {
        Principal user = AuthHelper.getPrincipalForPassword((PropertyKey)Principal.eMail, (String)emailOrUsername, (String)password);
        if (user != null) {
            boolean allowLoginBeforeConfirmation = (Boolean)Settings.RegistrationAllowLoginBeforeConfirmation.getValue();
            if (user.getProperty(User.confirmationKey) != null && !allowLoginBeforeConfirmation) {
                logger.warn("Login as {} not allowed before confirmation.", (Object)user);
                throw new AuthenticationException("Wrong username or password, or user is blocked. Check caps lock. Note: Username is case sensitive!");
            }
            AuthHelper.doLogin((HttpServletRequest)request, (Principal)user);
        }
        return user;
    }

    public void doLogout(HttpServletRequest request) {
        try {
            HttpSession session;
            Principal user = this.getUser(request, false);
            if (user != null) {
                AuthHelper.doLogout((HttpServletRequest)request, (Principal)user);
            }
            if ((session = request.getSession(false)) != null) {
                session.invalidate();
            }
        }
        catch (IllegalStateException | FrameworkException ex) {
            logger.warn("Error while logging out user", ex);
        }
    }

    protected Principal checkExternalAuthentication(HttpServletRequest request, HttpServletResponse response) throws FrameworkException {
        String path = PathHelper.clean((String)request.getPathInfo());
        String[] uriParts = PathHelper.getParts((String)path);
        logger.debug("Checking external authentication ...");
        if (uriParts == null || uriParts.length != 3 || !"oauth".equals(uriParts[0])) {
            logger.debug("Incorrect URI parts for OAuth process, need /oauth/<name>/<action>");
            return null;
        }
        String name = uriParts[1];
        String action = uriParts[2];
        StructrOAuthClient oauthServer = StructrOAuthClient.getServer(name);
        if (oauthServer == null) {
            logger.debug("No OAuth2 authentication server configured for {}", (Object)path);
            return null;
        }
        if ("login".equals(action)) {
            try {
                response.sendRedirect(oauthServer.getEndUserAuthorizationRequestUri(request));
                return null;
            }
            catch (Exception ex) {
                logger.error("Could not send redirect to authorization server", (Throwable)ex);
            }
        } else if ("auth".equals(action)) {
            String accessToken = oauthServer.getAccessToken(request);
            SecurityContext superUserContext = SecurityContext.getSuperUserInstance();
            if (accessToken != null) {
                logger.debug("Got access token {}", (Object)accessToken);
                String value = oauthServer.getCredential(request);
                logger.debug("Got credential value: {}", new Object[]{value});
                if (value != null) {
                    PropertyKey credentialKey = oauthServer.getCredentialKey();
                    Principal user = AuthHelper.getPrincipalForCredential((PropertyKey)credentialKey, (Object)value);
                    if (user == null && ((Boolean)Settings.RestUserAutocreate.getValue()).booleanValue()) {
                        user = RegistrationResource.createUser(superUserContext, credentialKey, value, true, this.getUserClass(), null);
                    }
                    if (user != null) {
                        AuthHelper.doLogin((HttpServletRequest)request, (Principal)user);
                        HtmlServlet.setNoCacheHeaders(response);
                        try {
                            logger.debug("Response status: {}", (Object)response.getStatus());
                            response.sendRedirect(oauthServer.getReturnUri());
                        }
                        catch (IOException ex) {
                            logger.error("Could not redirect to {}: {}", new Object[]{oauthServer.getReturnUri(), ex});
                        }
                        return user;
                    }
                }
            }
        }
        try {
            response.sendRedirect(oauthServer.getErrorUri());
        }
        catch (IOException ex) {
            logger.error("Could not redirect to {}: {}", new Object[]{oauthServer.getReturnUri(), ex});
        }
        return null;
    }

    public static void writeUnauthorized(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "BASIC realm=\"Restricted Access\"");
        response.sendError(401);
    }

    public static void writeNotFound(HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    public static void writeInternalServerError(HttpServletResponse response) {
        try {
            response.sendError(500);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Principal getUser(HttpServletRequest request, boolean tryLogin) throws FrameworkException {
        HttpSession session;
        Principal user = null;
        if (request.getAttribute("SESSION_IS_NEW") != null && (session = request.getSession(false)) != null) {
            user = AuthHelper.getPrincipalForSessionId((String)session.getId());
        }
        if (user == null) {
            String userName = request.getHeader("X-User");
            String password = request.getHeader("X-Password");
            String token = request.getHeader("X-StructrSessionToken");
            if (token != null) {
                user = AuthHelper.getPrincipalForSessionId((String)token);
            } else if (userName != null && password != null && tryLogin) {
                user = AuthHelper.getPrincipalForPassword((PropertyKey)AbstractNode.name, (String)userName, (String)password);
            }
        }
        return user;
    }

    public Class getUserClass() {
        String configuredCustomClassName = (String)Settings.RegistrationCustomUserClass.getValue();
        if (StringUtils.isEmpty((CharSequence)configuredCustomClassName)) {
            configuredCustomClassName = User.class.getSimpleName();
        }
        return StructrApp.getConfiguration().getNodeEntityClass(configuredCustomClassName);
    }

    static {
        methods.put("GET", Method.GET);
        methods.put("PUT", Method.PUT);
        methods.put("POST", Method.POST);
        methods.put("HEAD", Method.HEAD);
        methods.put("DELETE", Method.DELETE);
        methods.put("OPTIONS", Method.OPTIONS);
    }

    private static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS;

    }
}

