/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.LinkedTreeNode;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.util.Base64;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class FileHelper {
    private static final String UNKNOWN_MIME_TYPE = "application/octet-stream";
    private static final Logger logger = LoggerFactory.getLogger((String)FileHelper.class.getName());
    private static final MimetypesFileTypeMap mimeTypeMap = new MimetypesFileTypeMap(FileHelper.class.getResourceAsStream("/mime.types"));

    public static <T extends FileBase> T transformFile(SecurityContext securityContext, String uuid, Class<T> fileType) throws FrameworkException, IOException {
        AbstractFile existingFile = FileHelper.getFileByUuid(securityContext, uuid);
        if (existingFile != null) {
            existingFile.unlockSystemPropertiesOnce();
            existingFile.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractNode.type, (Object)(fileType == null ? org.structr.dynamic.File.class.getSimpleName() : fileType.getSimpleName())));
            existingFile = FileHelper.getFileByUuid(securityContext, uuid);
            return (T)(fileType != null ? (FileBase)fileType.cast((Object)existingFile) : (org.structr.dynamic.File)existingFile);
        }
        return null;
    }

    public static <T extends FileBase> T createFileBase64(SecurityContext securityContext, String rawData, Class<T> t) throws FrameworkException, IOException {
        Base64URIData uriData = new Base64URIData(rawData);
        return FileHelper.createFile(securityContext, uriData.getBinaryData(), uriData.getContentType(), t);
    }

    public static <T extends FileBase> T createFile(SecurityContext securityContext, InputStream fileStream, String contentType, Class<T> fileType, String name) throws FrameworkException, IOException {
        byte[] data = IOUtils.toByteArray((InputStream)fileStream);
        return FileHelper.createFile(securityContext, data, contentType, fileType, name);
    }

    public static <T extends FileBase> T createFile(SecurityContext securityContext, byte[] fileData, String contentType, Class<T> t, String name) throws FrameworkException, IOException {
        PropertyMap props = new PropertyMap();
        props.put((PropertyKey)AbstractNode.name, (Object)name);
        FileBase newFile = (FileBase)StructrApp.getInstance((SecurityContext)securityContext).create(t, props);
        FileHelper.setFileData(newFile, fileData, contentType);
        return (T)newFile;
    }

    public static <T extends FileBase> T createFile(SecurityContext securityContext, byte[] fileData, String contentType, Class<T> t) throws FrameworkException, IOException {
        return FileHelper.createFile(securityContext, fileData, contentType, t, null);
    }

    public static void decodeAndSetFileData(org.structr.dynamic.File file, String rawData) throws FrameworkException, IOException {
        Base64URIData uriData = new Base64URIData(rawData);
        FileHelper.setFileData(file, uriData.getBinaryData(), uriData.getContentType());
    }

    public static void setFileData(FileBase file, byte[] fileData, String contentType) throws FrameworkException, IOException {
        FileHelper.writeToFile(file, fileData);
        PropertyMap map = new PropertyMap();
        map.put((PropertyKey)FileBase.contentType, (Object)(contentType != null ? contentType : FileHelper.getContentMimeType(file)));
        map.put(FileBase.checksum, (Object)FileHelper.getChecksum(file));
        map.put(FileBase.size, (Object)FileHelper.getSize(file));
        map.put(FileBase.version, (Object)1);
        file.setProperties(file.getSecurityContext(), map);
    }

    public static void updateMetadata(FileBase file) throws FrameworkException, IOException {
        PropertyMap map = new PropertyMap();
        map.put((PropertyKey)FileBase.contentType, (Object)FileHelper.getContentMimeType(file));
        map.put(FileBase.checksum, (Object)FileHelper.getChecksum(file));
        map.put(FileBase.size, (Object)FileHelper.getSize(file));
        file.setProperties(file.getSecurityContext(), map);
    }

    public static String getBase64String(FileBase file) {
        try {
            InputStream is = file.getInputStream();
            if (is != null) {
                return Base64.encodeToString((byte[])IOUtils.toByteArray((InputStream)is), (boolean)false);
            }
        }
        catch (IOException ex) {
            logger.error("Could not get base64 string from file ", (Throwable)ex);
        }
        return null;
    }

    public static void writeToFile(org.structr.dynamic.File fileNode, InputStream inStream) throws FrameworkException, IOException {
        FileHelper.writeToFile((FileBase)fileNode, IOUtils.toByteArray((InputStream)inStream));
    }

    public static File writeToFile(FileBase fileNode, byte[] data) throws FrameworkException, IOException {
        PropertyMap properties = new PropertyMap();
        String id = (String)fileNode.getProperty((PropertyKey)GraphObject.id);
        if (id == null) {
            String newUuid;
            id = newUuid = UUID.randomUUID().toString().replaceAll("[\\-]+", "");
            fileNode.unlockSystemPropertiesOnce();
            properties.put((PropertyKey)GraphObject.id, (Object)newUuid);
        }
        properties.put(FileBase.relativeFilePath, (Object)(FileBase.getDirectoryPath(id) + "/" + id));
        fileNode.unlockSystemPropertiesOnce();
        fileNode.setProperties(fileNode.getSecurityContext(), properties);
        String filesPath = (String)Settings.FilesPath.getValue();
        File fileOnDisk = new File(filesPath + "/" + fileNode.getRelativeFilePath());
        fileOnDisk.getParentFile().mkdirs();
        FileUtils.writeByteArrayToFile((File)fileOnDisk, (byte[])data);
        return fileOnDisk;
    }

    public static File getFile(FileBase file) {
        return new File(FileHelper.getFilePath(file.getRelativeFilePath()));
    }

    public static Path getPath(FileBase file) {
        return Paths.get(FileHelper.getFilePath(file.getRelativeFilePath()), new String[0]);
    }

    public static String getContentMimeType(FileBase file) throws IOException {
        return FileHelper.getContentMimeType(file.getFileOnDisk(), (String)file.getProperty((PropertyKey)AbstractNode.name));
    }

    public static String getContentMimeType(File file, String name) throws IOException {
        String mimeType;
        if (name != null && (mimeType = mimeTypeMap.getContentType(name)) != null && !UNKNOWN_MIME_TYPE.equals(mimeType)) {
            return mimeType;
        }
        mimeType = Files.probeContentType(file.toPath());
        if (mimeType != null && !UNKNOWN_MIME_TYPE.equals(mimeType)) {
            return mimeType;
        }
        try {
            MagicMatch match = Magic.getMagicMatch((File)file, (boolean)false, (boolean)true);
            if (match != null) {
                return match.getMimeType();
            }
        }
        catch (MagicException | MagicMatchNotFoundException | MagicParseException throwable) {
            // empty catch block
        }
        return UNKNOWN_MIME_TYPE;
    }

    public static Long getChecksum(FileBase file) {
        String relativeFilePath = file.getRelativeFilePath();
        if (relativeFilePath != null) {
            String filePath = FileHelper.getFilePath(relativeFilePath);
            try {
                return FileHelper.getChecksum(new File(filePath));
            }
            catch (IOException ex) {
                logger.warn("Could not calculate checksum of file {}: {}", (Object)filePath, (Object)ex);
            }
        }
        return null;
    }

    public static Long getChecksum(File fileOnDisk) throws IOException {
        return FileUtils.checksumCRC32((File)fileOnDisk);
    }

    public static long getSize(FileBase file) {
        String path = file.getRelativeFilePath();
        if (path != null) {
            String filePath = FileHelper.getFilePath(path);
            try {
                File fileOnDisk = new File(filePath);
                long fileSize = fileOnDisk.length();
                logger.debug("File size of node {} ({}): {}", new Object[]{file.getUuid(), filePath, fileSize});
                return fileSize;
            }
            catch (Exception ex) {
                logger.warn("Could not calculate file size of file {}: {}", (Object)filePath, (Object)ex);
            }
        }
        return -1L;
    }

    public static AbstractFile getFileByAbsolutePath(SecurityContext securityContext, String absolutePath) {
        try {
            return (AbstractFile)StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(AbstractFile.class).and(AbstractFile.path, (Object)absolutePath).getFirst();
        }
        catch (FrameworkException ex) {
            logger.warn("File not found: {}", new Object[]{absolutePath});
            return null;
        }
    }

    public static AbstractFile getFileByUuid(SecurityContext securityContext, String uuid) {
        logger.debug("Search for file with uuid: {}", (Object)uuid);
        try {
            return (AbstractFile)StructrApp.getInstance((SecurityContext)securityContext).get(AbstractFile.class, uuid);
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to find a file by UUID {}: {}", (Object)uuid, (Object)fex.getMessage());
            return null;
        }
    }

    public static AbstractFile getFirstFileByName(SecurityContext securityContext, String name) {
        logger.debug("Search for file with name: {}", (Object)name);
        try {
            return (AbstractFile)StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(AbstractFile.class).andName(name).getFirst();
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to find a file for name {}: {}", (Object)name, (Object)fex.getMessage());
            return null;
        }
    }

    public static AbstractFile getFirstRootFileByName(SecurityContext securityContext, String name) {
        logger.debug("Search for file with name: {}", (Object)name);
        try {
            List files = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(AbstractFile.class).andName(name).getAsList();
            for (AbstractFile file : files) {
                if (file.getProperty((PropertyKey)AbstractFile.parent) != null) continue;
                return file;
            }
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to find a file for name {}: {}", (Object)name, (Object)fex.getMessage());
        }
        return null;
    }

    public static String getFolderPath(AbstractFile file) {
        LinkedTreeNode parentFolder = (LinkedTreeNode)file.getProperty((PropertyKey)AbstractFile.parent);
        String folderPath = (String)file.getProperty((PropertyKey)AbstractFile.name);
        if (folderPath == null) {
            folderPath = (String)file.getProperty((PropertyKey)GraphObject.id);
        }
        while (parentFolder != null) {
            folderPath = parentFolder.getName().concat("/").concat(folderPath);
            parentFolder = (LinkedTreeNode)parentFolder.getProperty(AbstractFile.parent);
        }
        return "/".concat(folderPath);
    }

    public static String getFilePath(String ... pathParts) {
        String filePath = (String)Settings.FilesPath.getValue();
        StringBuilder returnPath = new StringBuilder();
        returnPath.append(filePath);
        returnPath.append(filePath.endsWith("/") ? "" : "/");
        for (String pathPart : pathParts) {
            returnPath.append(pathPart);
        }
        return returnPath.toString();
    }

    public static Folder createFolderPath(SecurityContext securityContext, String path) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        if (path == null) {
            return null;
        }
        Folder folder = (Folder)FileHelper.getFileByAbsolutePath(securityContext, path);
        if (folder != null) {
            return folder;
        }
        String[] parts = PathHelper.getParts((String)path);
        String partialPath = "";
        for (String part : parts) {
            if ("..".equals(part) || ".".equals(part)) continue;
            Folder parent = folder;
            folder = (Folder)FileHelper.getFileByAbsolutePath(securityContext, partialPath = partialPath + "/" + part);
            if (folder == null) {
                folder = (Folder)app.create(Folder.class, part);
            }
            if (parent == null) continue;
            folder.setProperties(securityContext, new PropertyMap(AbstractFile.parent, (Object)parent));
        }
        return folder;
    }

    public static String getDateString() {
        return new SimpleDateFormat("yyyy-MM-dd-HHmmss").format(new Date());
    }

    public static class Base64URIData {
        private String contentType = null;
        private String data = null;

        public Base64URIData(String rawData) {
            if (rawData.contains(",")) {
                String[] parts = StringUtils.split((String)rawData, (String)",");
                if (parts.length == 2) {
                    this.contentType = StringUtils.substringBetween((String)parts[0], (String)"data:", (String)";base64");
                    this.data = parts[1];
                }
            } else {
                this.data = rawData;
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getData() {
            return this.data;
        }

        public byte[] getBinaryData() {
            return Base64.decode((String)this.data);
        }
    }
}

