/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.common;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.twelvemonkeys.image.AffineTransformOp;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.util.Base64;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Image;
import org.structr.web.entity.relation.Thumbnails;
import org.structr.web.property.ThumbnailProperty;

public abstract class ImageHelper
extends FileHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)ImageHelper.class.getName());

    public static Image createImage(SecurityContext securityContext, InputStream imageStream, String contentType, Class<? extends Image> imageType, String name, boolean markAsThumbnail) throws FrameworkException, IOException {
        return ImageHelper.createImageNode(securityContext, IOUtils.toByteArray((InputStream)imageStream), contentType, imageType, name, markAsThumbnail);
    }

    public static Image createImageNode(SecurityContext securityContext, byte[] imageData, String contentType, Class<? extends Image> imageType, String name, boolean markAsThumbnail) throws FrameworkException, IOException {
        PropertyMap props = new PropertyMap();
        props.put((PropertyKey)AbstractNode.type, (Object)(imageType == null ? Image.class.getSimpleName() : imageType.getSimpleName()));
        props.put(Image.isThumbnail, (Object)markAsThumbnail);
        props.put((PropertyKey)AbstractNode.name, (Object)name);
        Image newImage = (Image)StructrApp.getInstance((SecurityContext)securityContext).create(imageType, props);
        if (imageData != null && imageData.length > 0) {
            ImageHelper.setFileData(newImage, imageData, contentType);
        }
        return newImage;
    }

    public static void setImageData(Image img, byte[] imageData, String contentType) throws FrameworkException, IOException {
        ImageHelper.setFileData(img, imageData, contentType);
    }

    public static void findAndReconnectThumbnails(Image originalImage) {
        App app = StructrApp.getInstance();
        Integer origWidth = originalImage.getWidth();
        Integer origHeight = originalImage.getHeight();
        if (origWidth == null || origHeight == null) {
            logger.info("Could not determine width and heigth for {}", (Object)originalImage.getName());
            return;
        }
        for (ThumbnailProperty tnProp : new ThumbnailProperty[]{(ThumbnailProperty)Image.tnSmall, (ThumbnailProperty)Image.tnMid}) {
            int maxWidth = tnProp.getWidth();
            int maxHeight = tnProp.getHeight();
            boolean crop = tnProp.getCrop();
            String tnName = ImageHelper.getThumbnailName(originalImage.getName(), ImageHelper.getThumbnailWidth(origWidth, origHeight, maxWidth, maxHeight, crop), ImageHelper.getThumbnailHeight(origWidth, origHeight, maxWidth, maxHeight, crop));
            try {
                Image thumbnail = (Image)app.nodeQuery(Image.class).and((PropertyKey)Image.path, (Object)(PathHelper.getFolderPath((String)((String)originalImage.getProperty((PropertyKey)Image.path))) + "/" + tnName)).getFirst();
                if (thumbnail == null) continue;
                app.create((NodeInterface)originalImage, (NodeInterface)thumbnail, Thumbnails.class);
            }
            catch (FrameworkException ex) {
                logger.debug("Error reconnecting thumbnail " + tnName + " to original image " + originalImage.getName(), (Throwable)ex);
            }
        }
    }

    public static void findAndReconnectOriginalImage(Image thumbnail) {
        String originalImageName = thumbnail.getOriginalImageName();
        try {
            App app = StructrApp.getInstance();
            Image originalImage = (Image)app.nodeQuery(Image.class).and((PropertyKey)Image.path, (Object)(PathHelper.getFolderPath((String)((String)thumbnail.getProperty((PropertyKey)Image.path))) + "/" + originalImageName)).getFirst();
            if (originalImage != null) {
                PropertyMap relProperties = new PropertyMap();
                relProperties.put(Image.width, (Object)thumbnail.getWidth());
                relProperties.put(Image.height, (Object)thumbnail.getHeight());
                relProperties.put((PropertyKey)Image.checksum, (Object)originalImage.getChecksum());
                app.create((NodeInterface)originalImage, (NodeInterface)thumbnail, Thumbnails.class, relProperties);
            }
        }
        catch (FrameworkException ex) {
            logger.debug("Error reconnecting thumbnail " + thumbnail.getName() + " to original image " + originalImageName, (Throwable)ex);
        }
    }

    public static float getScaleRatio(int sourceWidth, int sourceHeight, int maxWidth, int maxHeight, boolean crop) {
        float scaleX = 1.0f * (float)sourceWidth / (float)maxWidth;
        float scaleY = 1.0f * (float)sourceHeight / (float)maxHeight;
        float scale = crop ? Math.min(scaleX, scaleY) : Math.max(scaleX, scaleY);
        return scale;
    }

    public static int getThumbnailWidth(int sourceWidth, int sourceHeight, int maxWidth, int maxHeight, boolean crop) {
        return Math.max(4, Math.round((float)sourceWidth / ImageHelper.getScaleRatio(sourceWidth, sourceHeight, maxWidth, maxHeight, crop)));
    }

    public static int getThumbnailHeight(int sourceWidth, int sourceHeight, int maxWidth, int maxHeight, boolean crop) {
        return Math.max(4, Math.round((float)sourceHeight / ImageHelper.getScaleRatio(sourceWidth, sourceHeight, maxWidth, maxHeight, crop)));
    }

    public static int getThumbnailWidth(Image originalImage, int maxWidth, int maxHeight, boolean crop) {
        return ImageHelper.getThumbnailWidth(originalImage.getWidth(), originalImage.getHeight(), maxWidth, maxHeight, crop);
    }

    public static int getThumbnailHeight(Image originalImage, int maxWidth, int maxHeight, boolean crop) {
        return ImageHelper.getThumbnailHeight(originalImage.getWidth(), originalImage.getHeight(), maxWidth, maxHeight, crop);
    }

    public static Thumbnail createThumbnail(Image originalImage, int maxWidth, int maxHeight) {
        return ImageHelper.createThumbnail(originalImage, maxWidth, maxHeight, false);
    }

    public static Thumbnail createThumbnail(Image originalImage, int maxWidth, int maxHeight, boolean crop) {
        return ImageHelper.createThumbnail(originalImage, maxWidth, maxHeight, null, crop, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Thumbnail createThumbnail(Image originalImage, int maxWidth, int maxHeight, String formatString, boolean crop, Integer reqOffsetX, Integer reqOffsetY) {
        String imageFormatString = ImageHelper.getImageFormatString(originalImage);
        Thumbnail.Format format = formatString != null ? Thumbnail.Format.valueOf(formatString) : (imageFormatString != null ? Thumbnail.Format.valueOf(imageFormatString) : Thumbnail.defaultFormat);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Thumbnail tn = new Thumbnail();
        try (InputStream in = originalImage.getInputStream();){
            if (in == null || in.available() <= 0) {
                logger.debug("InputStream of original image {} ({}) is null or not available ({} bytes)", new Object[]{originalImage.getName(), originalImage.getId(), in != null ? in.available() : -1});
                Thumbnail thumbnail = null;
                return thumbnail;
            }
            long start = System.nanoTime();
            BufferedImage source = ImageHelper.getRotatedImage(originalImage);
            if (source == null) {
                logger.debug("Thumbnail could not be created");
                Thumbnail sourceWidth = null;
                return sourceWidth;
            }
            int sourceWidth = source.getWidth();
            int sourceHeight = source.getHeight();
            PropertyMap properties = new PropertyMap();
            properties.put(Image.width, (Object)sourceWidth);
            properties.put(Image.height, (Object)sourceHeight);
            originalImage.setProperties(originalImage.getSecurityContext(), properties);
            float scale = ImageHelper.getScaleRatio(sourceWidth, sourceHeight, maxWidth, maxHeight, crop);
            if ((double)scale > 1.0) {
                int destWidth = ImageHelper.getThumbnailWidth(sourceWidth, sourceHeight, maxWidth, maxHeight, crop);
                int destHeight = ImageHelper.getThumbnailHeight(sourceWidth, sourceHeight, maxWidth, maxHeight, crop);
                if (crop) {
                    int offsetX = reqOffsetX != null ? reqOffsetX : Math.abs(maxWidth - destWidth) / 2;
                    int offsetY = reqOffsetY != null ? reqOffsetY : Math.abs(maxHeight - destHeight) / 2;
                    Integer[] dims = ImageHelper.finalImageDimensions(offsetX, offsetY, maxWidth, maxHeight, sourceWidth, sourceHeight);
                    logger.debug("Offset and Size (x,y,w,h): {},{},{},{}", new Object[]{dims[0], dims[1], dims[2], dims[3]});
                    net.coobird.thumbnailator.Thumbnails.of((BufferedImage[])new BufferedImage[]{source}).scale((double)(1.0f / scale)).sourceRegion(dims[0].intValue(), dims[1].intValue(), dims[2].intValue(), dims[3].intValue()).outputFormat(format.name()).toOutputStream((OutputStream)baos);
                    tn.setWidth(dims[2]);
                    tn.setHeight(dims[3]);
                } else {
                    net.coobird.thumbnailator.Thumbnails.of((BufferedImage[])new BufferedImage[]{source}).scale((double)(1.0f / scale)).outputFormat(format.name()).toOutputStream((OutputStream)baos);
                    tn.setWidth(destWidth);
                    tn.setHeight(destHeight);
                }
            } else {
                ImageIO.write((RenderedImage)source, format.name(), (OutputStream)baos);
                tn.setWidth(sourceWidth);
                tn.setHeight(sourceHeight);
            }
            long end = System.nanoTime();
            long time = (end - start) / 1000000L;
            logger.debug("Thumbnail created. Reading, scaling and writing took {} ms", (Object)time);
            tn.setBytes(baos.toByteArray());
            Thumbnail thumbnail = tn;
            return thumbnail;
        }
        catch (Throwable t) {
            logger.warn("Unable to create thumbnail for image with ID {}.", (Object)originalImage.getUuid(), (Object)t);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Thumbnail createCroppedImage(Image originalImage, int maxWidth, int maxHeight, Integer reqOffsetX, Integer reqOffsetY, String formatString) {
        String imageFormatString = ImageHelper.getImageFormatString(originalImage);
        Thumbnail.Format format = formatString != null ? Thumbnail.Format.valueOf(formatString) : (imageFormatString != null ? Thumbnail.Format.valueOf(imageFormatString) : Thumbnail.defaultFormat);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Thumbnail tn = new Thumbnail();
        try (InputStream in = originalImage.getInputStream();){
            if (in == null || in.available() <= 0) {
                logger.debug("InputStream of original image {} ({}) is null or not available ({} bytes)", new Object[]{originalImage.getName(), originalImage.getId(), in != null ? in.available() : -1});
                Thumbnail thumbnail = null;
                return thumbnail;
            }
            long start = System.nanoTime();
            BufferedImage source = ImageHelper.getRotatedImage(originalImage);
            if (source != null) {
                int sourceWidth = source.getWidth();
                int sourceHeight = source.getHeight();
                PropertyMap properties = new PropertyMap();
                properties.put(Image.width, (Object)sourceWidth);
                properties.put(Image.height, (Object)sourceHeight);
                originalImage.setProperties(originalImage.getSecurityContext(), properties);
                Object result = null;
                int offsetX = reqOffsetX != null ? reqOffsetX : 0;
                int offsetY = reqOffsetY != null ? reqOffsetY : 0;
                Integer[] dims = ImageHelper.finalImageDimensions(offsetX, offsetY, maxWidth, maxHeight, sourceWidth, sourceHeight);
                logger.debug("Offset and Size (x,y,w,h): {},{},{},{}", new Object[]{dims[0], dims[1], dims[2], dims[3]});
                net.coobird.thumbnailator.Thumbnails.of((BufferedImage[])new BufferedImage[]{source}).sourceRegion(dims[0].intValue(), dims[1].intValue(), dims[2].intValue(), dims[3].intValue()).scale(1.0).outputFormat(format.name()).toOutputStream((OutputStream)baos);
                tn.setWidth(dims[2]);
                tn.setHeight(dims[3]);
                long end = System.nanoTime();
                long time = (end - start) / 1000000L;
                logger.debug("Cropped image created. Reading, scaling and writing took {} ms", (Object)time);
                tn.setBytes(baos.toByteArray());
                Thumbnail thumbnail = tn;
                return thumbnail;
            }
            logger.debug("Cropped image could not be created");
            Thumbnail sourceWidth = null;
            return sourceWidth;
        }
        catch (Throwable t) {
            logger.warn("Unable to create cropped image for image with ID {}.", (Object)originalImage.getUuid(), (Object)t);
            return null;
        }
    }

    public static BufferedImage getRotatedImage(FileBase originalImage) {
        try {
            ImageInputStream in = ImageIO.createImageInputStream(originalImage.getInputStream());
            int orientation = ImageHelper.getOrientation(originalImage);
            BufferedImage source = ImageIO.read(in);
            if (source != null) {
                int sourceWidth = source.getWidth();
                int sourceHeight = source.getHeight();
                AffineTransform affineTransform = new AffineTransform();
                switch (orientation) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        affineTransform.scale(-1.0, 1.0);
                        affineTransform.translate(-sourceWidth, 0.0);
                        break;
                    }
                    case 3: {
                        affineTransform.translate(sourceWidth, sourceHeight);
                        affineTransform.rotate(Math.PI);
                        break;
                    }
                    case 4: {
                        affineTransform.scale(1.0, -1.0);
                        affineTransform.translate(0.0, -sourceHeight);
                        break;
                    }
                    case 5: {
                        affineTransform.rotate(-1.5707963267948966);
                        affineTransform.scale(-1.0, 1.0);
                        break;
                    }
                    case 6: {
                        affineTransform.translate(sourceHeight, 0.0);
                        affineTransform.rotate(1.5707963267948966);
                        break;
                    }
                    case 7: {
                        affineTransform.scale(-1.0, 1.0);
                        affineTransform.translate(-sourceHeight, 0.0);
                        affineTransform.translate(0.0, sourceWidth);
                        affineTransform.rotate(4.71238898038469);
                        break;
                    }
                    case 8: {
                        affineTransform.translate(0.0, sourceWidth);
                        affineTransform.rotate(4.71238898038469);
                        break;
                    }
                }
                AffineTransformOp op = new AffineTransformOp(affineTransform, 3);
                BufferedImage destinationImage = op.createCompatibleDestImage(source, ColorModel.getRGBdefault());
                Graphics2D g = destinationImage.createGraphics();
                g.setBackground(Color.WHITE);
                g.clearRect(0, 0, destinationImage.getWidth(), destinationImage.getHeight());
                destinationImage = op.filter(source, destinationImage);
                return destinationImage;
            }
        }
        catch (IOException ex) {
            logger.warn("Unable to rotate image", (Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] normalizeJpegImage(byte[] original) {
        BufferedImage source;
        ByteArrayOutputStream out;
        ByteArrayInputStream in;
        block9: {
            if (original == null) {
                return new byte[0];
            }
            in = new ByteArrayInputStream(original);
            if (original[0] == -1 && original[1] == -39 && original[2] == -1 && original[3] == -40) {
                in.skip(4L);
            }
            out = new ByteArrayOutputStream();
            source = ImageIO.read(in);
            if (source != null) break block9;
            byte[] byArray = original;
            return byArray;
        }
        try {
            ImageIO.write((RenderedImage)source, "jpeg", (OutputStream)out);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    public static void updateMetadata(FileBase image) throws FrameworkException, IOException {
        ImageHelper.updateMetadata(image, image.getInputStream());
    }

    public static void updateMetadata(FileBase image, InputStream fis) throws FrameworkException, IOException {
        BufferedImage source = ImageIO.read(fis);
        if (source != null) {
            int sourceWidth = source.getWidth();
            int sourceHeight = source.getHeight();
            PropertyMap map = new PropertyMap();
            map.put(Image.width, (Object)sourceWidth);
            map.put(Image.height, (Object)sourceHeight);
            map.put(Image.orientation, (Object)ImageHelper.getOrientation(image));
            image.setProperties(image.getSecurityContext(), map);
        }
    }

    public static Integer[] finalImageDimensions(int offsetX, int offsetY, int requestedWidth, int requestedHeight, int sourceWidth, int sourceHeight) {
        Integer[] finalDimensions = new Integer[4];
        int overhangLeftX = Math.min(offsetX, 0);
        int overhangRightX = Math.max(offsetX + requestedWidth - sourceWidth, 0);
        int overhangTopY = Math.min(offsetY, 0);
        int overhangBottomY = Math.max(offsetY + requestedHeight - sourceHeight, 0);
        finalDimensions[0] = Math.min(Math.max(offsetX, 0), sourceWidth);
        finalDimensions[1] = Math.min(Math.max(offsetY, 0), sourceHeight);
        finalDimensions[2] = requestedWidth + overhangLeftX - overhangRightX;
        finalDimensions[3] = requestedHeight + overhangTopY - overhangBottomY;
        return finalDimensions;
    }

    public static String getBase64String(File file) {
        try {
            InputStream dataStream = file.getInputStream();
            if (dataStream != null) {
                return Base64.encodeToString((byte[])IOUtils.toByteArray((InputStream)file.getInputStream()), (boolean)false);
            }
        }
        catch (IOException ex) {
            logger.error("Could not get base64 string from file ", (Throwable)ex);
        }
        return null;
    }

    public static boolean isImageType(String urlString) {
        String[] imageExtensions;
        if (urlString == null || StringUtils.isBlank((CharSequence)urlString)) {
            return false;
        }
        String extension = StringUtils.substringAfterLast((String)urlString.toLowerCase(), (String)".");
        for (String ext : imageExtensions = new String[]{"png", "gif", "jpg", "jpeg", "bmp", "tif", "tiff"}) {
            if (!ext.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static String getImageFormatString(Image img) {
        String contentType = img.getContentType();
        if (contentType == null) {
            return null;
        }
        return StringUtils.substringAfterLast((String)contentType.toLowerCase(), (String)"/");
    }

    public static boolean isSwfType(String urlString) {
        String[] swfExtensions;
        if (urlString == null || StringUtils.isBlank((CharSequence)urlString)) {
            return false;
        }
        String extension = StringUtils.substringAfterLast((String)urlString.toLowerCase(), (String)".");
        for (String ext : swfExtensions = new String[]{"swf"}) {
            if (!ext.equals(extension)) continue;
            return true;
        }
        return false;
    }

    private static Metadata getMetadata(FileBase originalImage) {
        try {
            InputStream in = originalImage.getInputStream();
            if (in != null && in.available() > 0) {
                return ImageMetadataReader.readMetadata((InputStream)in);
            }
        }
        catch (ImageProcessingException | IOException ex) {
            logger.warn("Unable to get metadata information from image stream", ex);
        }
        return null;
    }

    public static int getOrientation(FileBase originalImage) {
        try {
            Metadata metadata = ImageHelper.getMetadata(originalImage);
            ExifIFD0Directory exifIFD0Directory = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            if (exifIFD0Directory != null && exifIFD0Directory.containsTag(274)) {
                int orientation = exifIFD0Directory.getInt(274);
                originalImage.setProperty((PropertyKey)Image.orientation, orientation);
                return orientation;
            }
        }
        catch (MetadataException ex) {
            logger.warn("Unable to get orientation information from EXIF metadata.", (Throwable)ex);
        }
        catch (FrameworkException ex) {
            logger.warn("Unable to store orientation information on image {} ({})", new Object[]{originalImage.getName(), originalImage.getId()});
        }
        return 1;
    }

    public static String getVariantName(String originalImageName, Integer width, Integer height, String variant) {
        return originalImageName + variant + width + "x" + height;
    }

    public static String getThumbnailName(String originalImageName, Integer tnWidth, Integer tnHeight) {
        return ImageHelper.getVariantName(originalImageName, tnWidth, tnHeight, "_thumb_");
    }

    public static class Thumbnail {
        public static Format defaultFormat = Format.jpeg;
        private byte[] bytes;
        private int height;
        private int width;
        private Format format;

        public Thumbnail() {
        }

        public Thumbnail(byte[] bytes) {
            this.bytes = bytes;
        }

        public Thumbnail(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Thumbnail(byte[] bytes, int width, int height) {
            this.bytes = bytes;
            this.width = width;
            this.height = height;
        }

        public Thumbnail(byte[] bytes, int width, int height, String formatString) {
            this.bytes = bytes;
            this.width = width;
            this.height = height;
            this.format = Format.valueOf(formatString);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Format getFormat() {
            return this.format;
        }

        public String getFormatAsString() {
            return this.format.name();
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setFormat(Format format) {
            this.format = format;
        }

        public void setFormatByString(String formatString) {
            this.format = Format.valueOf(formatString);
        }

        public static enum Format {
            png,
            jpg,
            jpeg,
            gif,
            tiff;

        }
    }

    public static class Base64URIData {
        private String contentType;
        private String data;

        public Base64URIData(String rawData) {
            String[] parts = StringUtils.split((String)rawData, (String)",");
            this.data = parts[1];
            this.contentType = StringUtils.substringBetween((String)parts[0], (String)"data:", (String)";base64");
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getData() {
            return this.data;
        }

        public byte[] getBinaryData() {
            return Base64.decode((String)this.data);
        }
    }
}

