/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.diff;

import java.util.List;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.property.PropertyKey;
import org.structr.web.diff.InvertibleModificationOperation;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class MoveOperation
extends InvertibleModificationOperation {
    private List<String> siblingHashes = null;
    private DOMNode originalNode = null;
    private String parentHash = null;
    private DOMNode newNode = null;

    public MoveOperation(Map<String, DOMNode> hashMappedExistingNodes, String parentHash, List<String> siblingHashes, DOMNode newNode, DOMNode originalNode) {
        super(hashMappedExistingNodes);
        this.siblingHashes = siblingHashes;
        this.originalNode = originalNode;
        this.parentHash = parentHash;
        this.newNode = newNode;
    }

    public String toString() {
        if (this.originalNode instanceof Content) {
            return "Move Content(" + this.originalNode.getIdHashOrProperty() + ")";
        }
        return "Move " + (String)this.originalNode.getProperty((PropertyKey)DOMElement.tag) + "(" + this.originalNode.getIdHashOrProperty() + ")";
    }

    @Override
    public void apply(App app, Page sourcePage, Page newPage) throws FrameworkException {
        InvertibleModificationOperation.InsertPosition insertPosition = this.findInsertPosition(sourcePage, this.parentHash, this.siblingHashes, this.newNode);
        if (insertPosition != null) {
            DOMNode parent = insertPosition.getParent();
            DOMNode sibling = insertPosition.getSibling();
            Node originalSibling = this.originalNode.getNextSibling();
            Node originalParent = this.originalNode.getParentNode();
            if (parent.isSynced()) {
                return;
            }
            if (parent.equals(originalParent)) {
                if (sibling != null && sibling.equals(originalSibling)) {
                    return;
                }
                if (sibling == null && originalSibling == null) {
                    return;
                }
            }
            boolean found = false;
            int count = 0;
            for (Node localSibling = sibling; localSibling != null && count++ < 10; localSibling = localSibling.getParentNode()) {
                try {
                    parent.insertBefore(this.originalNode, localSibling);
                    found = true;
                    break;
                }
                catch (DOMException dOMException) {
                    continue;
                }
            }
            if (!found) {
                parent.appendChild(this.originalNode);
            }
        }
    }

    @Override
    public InvertibleModificationOperation revert() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return 300;
    }
}

