/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UniqueToken;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.LinkedTreeNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.CollectionIdProperty;
import org.structr.core.property.EndNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.EntityIdProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.relation.FileChildren;
import org.structr.web.entity.relation.FileSiblings;
import org.structr.web.entity.relation.FolderChildren;
import org.structr.web.property.PathProperty;

public class AbstractFile
extends LinkedTreeNode<FileChildren, FileSiblings, AbstractFile> {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractFile.class.getName());
    public static final Property<Folder> parent = new StartNode("parent", FolderChildren.class);
    public static final Property<List<AbstractFile>> children = new EndNodes("children", FileChildren.class);
    public static final Property<AbstractFile> previousSibling = new StartNode("previousSibling", FileSiblings.class);
    public static final Property<AbstractFile> nextSibling = new EndNode("nextSibling", FileSiblings.class);
    public static final Property<List<String>> childrenIds = new CollectionIdProperty("childrenIds", children);
    public static final Property<String> nextSiblingId = new EntityIdProperty("nextSiblingId", nextSibling);
    public static final Property<String> path = new PathProperty("path").indexed().readOnly();
    public static final Property<String> parentId = new EntityIdProperty("parentId", parent);
    public static final Property<Boolean> hasParent = new BooleanProperty("hasParent").indexed();
    public static final Property<Boolean> includeInFrontendExport = new BooleanProperty("includeInFrontendExport").cmis().indexed();
    public static final View defaultView = new View(AbstractFile.class, "public", new Property[]{path});
    public static final View uiView = new View(AbstractFile.class, "ui", new Property[]{path});

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        boolean valid = true;
        if (((Boolean)Settings.UniquePaths.getValue()).booleanValue()) {
            valid = this.validateAndRenameFileOnce(securityContext, errorBuffer);
        }
        return valid && super.onCreation(securityContext, errorBuffer);
    }

    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        boolean valid = true;
        if (((Boolean)Settings.UniquePaths.getValue()).booleanValue()) {
            valid = this.validatePath(securityContext, errorBuffer);
        }
        return valid && super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    public boolean validatePath(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        String filePath = (String)this.getProperty((PropertyKey)path);
        if (filePath != null) {
            List files = StructrApp.getInstance().nodeQuery(AbstractFile.class).and(path, (Object)filePath).getAsList();
            for (AbstractFile file : files) {
                if (file.getUuid().equals(this.getUuid())) continue;
                if (errorBuffer != null) {
                    UniqueToken token = new UniqueToken(AbstractFile.class.getSimpleName(), path, file.getUuid());
                    token.setValue((Object)filePath);
                    errorBuffer.add((ErrorToken)token);
                }
                return false;
            }
        }
        return true;
    }

    public boolean validateAndRenameFileOnce(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        boolean valid = this.validatePath(securityContext, null);
        if (!valid) {
            String originalPath = (String)this.getProperty((PropertyKey)path);
            String newName = ((String)this.getProperty((PropertyKey)name)).concat("_").concat(FileHelper.getDateString());
            this.setProperty((PropertyKey)name, newName);
            valid = this.validatePath(securityContext, errorBuffer);
            if (valid) {
                logger.warn("File {} already exists, renaming to {}", new Object[]{originalPath, newName});
            } else {
                logger.warn("File {} already existed. Tried renaming to {} and failed. Aborting.", new Object[]{originalPath, newName});
            }
        }
        return valid;
    }

    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        valid &= this.nonEmpty(name, errorBuffer);
        return valid &= ValidationHelper.isValidStringMatchingRegex((GraphObject)this, (PropertyKey)name, (String)"[^\\/\\x00]+", (ErrorBuffer)errorBuffer);
    }

    public Class<FileChildren> getChildLinkType() {
        return FileChildren.class;
    }

    public Class<FileSiblings> getSiblingLinkType() {
        return FileSiblings.class;
    }

    public boolean includeInFrontendExport() {
        if (((Boolean)this.getProperty((PropertyKey)FileBase.includeInFrontendExport)).booleanValue()) {
            return true;
        }
        Folder _parent = (Folder)((Object)this.getProperty((PropertyKey)FileBase.parent));
        if (_parent != null) {
            return _parent.includeInFrontendExport();
        }
        return false;
    }
}

