/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaHelper;
import org.structr.web.common.RenderContext;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;

public class Component
extends DOMElement {
    private static final int MAX_DEPTH = 10;
    public static final String REQUEST_CONTAINS_UUID_IDENTIFIER = "request_contains_uuids";
    private static final Logger logger = LoggerFactory.getLogger((String)Component.class.getName());
    public static final Property<Integer> position = new IntProperty("position").indexed();
    public static final Property<String> kind = new StringProperty("kind").indexed();
    public static final View uiView = new View(Component.class, "ui", new Property[]{type, name, kind});
    public static final View publicView = new View(Component.class, "public", new Property[]{type, name, kind});
    private final Map<String, AbstractNode> contentNodes = new WeakHashMap<String, AbstractNode>();
    private final Set<String> subTypes = new LinkedHashSet<String>();

    public void onNodeDeletion() {
        try {
            App app = StructrApp.getInstance((SecurityContext)this.securityContext);
            for (AbstractNode contentNode : this.contentNodes.values()) {
                app.delete((NodeInterface)contentNode);
            }
        }
        catch (Throwable t) {
            logger.error("Exception while deleting nested Components: {}", (Object)t.getMessage());
        }
    }

    private void collectChildren(List<Component> children, DOMNode startNode, int depth, AbstractRelationship ref) {
        if (depth > 10) {
            return;
        }
        if (ref != null && startNode instanceof Component) {
            children.add((Component)startNode);
            return;
        }
        for (AbstractRelationship abstractRelationship : startNode.getChildRelationships()) {
            DOMNode endNode = (DOMNode)abstractRelationship.getTargetNode();
            if (endNode == null) continue;
            this.collectChildren(children, endNode, depth + 1, abstractRelationship);
        }
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        LinkedHashSet<PropertyKey> augmentedPropertyKeys = new LinkedHashSet<PropertyKey>();
        for (PropertyKey propertyKey : super.getPropertyKeys(propertyView)) {
            augmentedPropertyKeys.add(propertyKey);
        }
        for (String string : this.contentNodes.keySet()) {
            augmentedPropertyKeys.add((PropertyKey)new GenericProperty(string));
        }
        for (String string : this.subTypes) {
            augmentedPropertyKeys.add((PropertyKey)new GenericProperty(string.toLowerCase().concat("s")));
        }
        return augmentedPropertyKeys;
    }

    public <T> T getProperty(PropertyKey<T> key) {
        if (this.contentNodes.containsKey(key.dbName())) {
            AbstractNode node = this.contentNodes.get(key.dbName());
            if (node != null && node != this) {
                return (T)node.getProperty(Content.content);
            }
        } else if (this.subTypes.contains(SchemaHelper.normalizeEntityName((String)key.dbName()))) {
            LinkedList<Component> results = new LinkedList<Component>();
            this.collectChildren(results, this, 0, null);
            return (T)results;
        }
        return (T)super.getProperty(key);
    }

    public Map<String, AbstractNode> getContentNodes() {
        return this.contentNodes;
    }

    private static boolean hasAttribute(HttpServletRequest request, String key) {
        return key != null && request.getAttribute(key) != null;
    }

    public static boolean isVisible(HttpServletRequest request, AbstractNode node, AbstractRelationship incomingRelationship, String parentComponentId) {
        if (request == null) {
            return true;
        }
        if (node instanceof Component) {
            Boolean requestContainsUuidsValue = (Boolean)request.getAttribute(REQUEST_CONTAINS_UUID_IDENTIFIER);
            boolean requestContainsUuids = false;
            if (requestContainsUuidsValue != null) {
                requestContainsUuids = requestContainsUuidsValue;
            }
            String componentId = (String)node.getProperty((PropertyKey)GraphObject.id);
            if (requestContainsUuids) {
                return Component.hasAttribute(request, componentId) || parentComponentId != null;
            }
            return true;
        }
        return false;
    }

    public <T> Object setProperty(PropertyKey<T> key, T value) throws FrameworkException {
        if (this.contentNodes.containsKey(key.dbName())) {
            AbstractNode node = this.contentNodes.get(key.dbName());
            if (node != null) {
                return node.setProperty(Content.content, (Object)value.toString());
            }
        } else {
            return super.setProperty(key, value);
        }
        return null;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public void render(RenderContext renderContext, int depth) throws FrameworkException {
        super.render(renderContext, depth - 1);
    }
}

