/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.util.Collection;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.structr.api.util.Iterables;
import org.structr.cmis.CMISInfo;
import org.structr.cmis.info.CMISDocumentInfo;
import org.structr.cmis.info.CMISFolderInfo;
import org.structr.cmis.info.CMISItemInfo;
import org.structr.cmis.info.CMISPolicyInfo;
import org.structr.cmis.info.CMISRelationshipInfo;
import org.structr.cmis.info.CMISSecondaryInfo;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.notion.Notion;
import org.structr.core.notion.PropertySetNotion;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StartNode;
import org.structr.files.cmis.config.StructrFolderActions;
import org.structr.schema.SchemaService;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Image;
import org.structr.web.entity.User;
import org.structr.web.entity.relation.Files;
import org.structr.web.entity.relation.Folders;
import org.structr.web.entity.relation.Images;
import org.structr.web.entity.relation.UserHomeDir;

public class Folder
extends AbstractFile
implements CMISInfo,
CMISFolderInfo {
    public static final Property<List<Folder>> folders = new EndNodes("folders", Folders.class, (Notion)new PropertySetNotion(new PropertyKey[]{id, name}));
    public static final Property<List<FileBase>> files = new EndNodes("files", Files.class, (Notion)new PropertySetNotion(new PropertyKey[]{id, name}));
    public static final Property<List<Image>> images = new EndNodes("images", Images.class, (Notion)new PropertySetNotion(new PropertyKey[]{id, name}));
    public static final Property<Boolean> isFolder = new ConstantBooleanProperty("isFolder", true);
    public static final Property<User> homeFolderOfUser = new StartNode("homeFolderOfUser", UserHomeDir.class);
    public static final Property<Integer> position = new IntProperty("position").cmis().indexed();
    public static final View publicView = new View(Folder.class, "public", new Property[]{id, type, name, owner, isFolder, folders, files, parentId, visibleToPublicUsers, visibleToAuthenticatedUsers});
    public static final View uiView = new View(Folder.class, "ui", new Property[]{parent, owner, folders, files, images, isFolder, includeInFrontendExport});

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            this.setHasParent();
            return true;
        }
        return false;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            this.setHasParent();
            return true;
        }
        return false;
    }

    public List<GraphObject> getSyncData() throws FrameworkException {
        List data = super.getSyncData();
        data.addAll((Collection)this.getProperty((PropertyKey)images));
        data.addAll(Iterables.toList((Iterable)this.getOutgoingRelationships(Images.class)));
        data.addAll((Collection)this.getProperty((PropertyKey)files));
        data.addAll(Iterables.toList((Iterable)this.getOutgoingRelationships(Files.class)));
        data.addAll((Collection)this.getProperty((PropertyKey)folders));
        data.addAll(Iterables.toList((Iterable)this.getOutgoingRelationships(Folders.class)));
        return data;
    }

    public CMISInfo getCMISInfo() {
        return this;
    }

    public BaseTypeId getBaseTypeId() {
        return BaseTypeId.CMIS_FOLDER;
    }

    public CMISFolderInfo getFolderInfo() {
        return this;
    }

    public CMISDocumentInfo getDocumentInfo() {
        return null;
    }

    public CMISItemInfo geItemInfo() {
        return null;
    }

    public CMISRelationshipInfo getRelationshipInfo() {
        return null;
    }

    public CMISPolicyInfo getPolicyInfo() {
        return null;
    }

    public CMISSecondaryInfo getSecondaryInfo() {
        return null;
    }

    public String getParentId() {
        return (String)this.getProperty((PropertyKey)FileBase.parentId);
    }

    public String getPath() {
        return (String)this.getProperty((PropertyKey)AbstractFile.path);
    }

    public AllowableActions getAllowableActions() {
        return StructrFolderActions.getInstance();
    }

    public String getChangeToken() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHasParent() throws FrameworkException {
        Folder folder = this;
        synchronized (folder) {
            SecurityContext previousSecurityContext = this.securityContext;
            this.securityContext = SecurityContext.getSuperUserInstance();
            this.setProperties(this.securityContext, new PropertyMap((PropertyKey)hasParent, (Object)(this.getProperty((PropertyKey)parentId) != null ? 1 : 0)));
            this.securityContext = previousSecurityContext;
        }
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"Folder", (String)Folder.class.getName());
    }
}

