/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.dom;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profiles.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.java.textilej.parser.MarkupParser;
import net.java.textilej.parser.markup.Dialect;
import net.java.textilej.parser.markup.confluence.ConfluenceDialect;
import net.java.textilej.parser.markup.mediawiki.MediaWikiDialect;
import net.java.textilej.parser.markup.textile.TextileDialect;
import net.java.textilej.parser.markup.trac.TracWikiDialect;
import org.apache.commons.lang3.StringUtils;
import org.asciidoctor.Asciidoctor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Adapter;
import org.structr.core.GraphObject;
import org.structr.core.entity.Favoritable;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.core.script.Scripting;
import org.structr.schema.NonIndexed;
import org.structr.schema.action.ActionContext;
import org.structr.web.common.AsyncBuffer;
import org.structr.web.common.RenderContext;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.html.Textarea;
import org.structr.web.entity.relation.Sync;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

public class Content
extends DOMNode
implements Text,
NonIndexed,
Favoritable {
    private static final Logger logger = LoggerFactory.getLogger((String)Content.class.getName());
    public static final Property<String> contentType = new StringProperty("contentType").indexed();
    public static final Property<String> content = new StringProperty("content").indexed();
    public static final Property<Boolean> isContent = new ConstantBooleanProperty("isContent", true);
    private static final Map<String, Adapter<String, String>> contentConverters = new LinkedHashMap<String, Adapter<String, String>>();
    private static final ThreadLocalAsciiDocProcessor asciiDocProcessor = new ThreadLocalAsciiDocProcessor();
    private static final ThreadLocalTracWikiProcessor tracWikiProcessor = new ThreadLocalTracWikiProcessor();
    private static final ThreadLocalTextileProcessor textileProcessor = new ThreadLocalTextileProcessor();
    private static final ThreadLocalFlexMarkProcessor flexMarkProcessor = new ThreadLocalFlexMarkProcessor();
    private static final ThreadLocalMediaWikiProcessor mediaWikiProcessor = new ThreadLocalMediaWikiProcessor();
    private static final ThreadLocalConfluenceProcessor confluenceProcessor = new ThreadLocalConfluenceProcessor();
    public static final View uiView = new View(Content.class, "ui", new Property[]{content, contentType, parent, pageId, syncedNodes, sharedComponent, sharedComponentConfiguration, dataKey, restQuery, cypherQuery, xpathQuery, functionQuery, hideOnDetail, hideOnIndex, showForLocales, hideForLocales, showConditions, hideConditions, isContent, isDOMNode, isFavoritable});
    public static final View publicView = new View(Content.class, "public", new Property[]{content, contentType, parent, pageId, syncedNodes, sharedComponent, sharedComponentConfiguration, dataKey, restQuery, cypherQuery, xpathQuery, functionQuery, hideOnDetail, hideOnIndex, showForLocales, hideForLocales, showConditions, hideConditions, isContent, isDOMNode, isFavoritable});

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.isValid(errorBuffer)) {
            if (this.getProperty((PropertyKey)contentType) == null) {
                this.setProperty((PropertyKey)contentType, "text/plain");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            Content otherNode;
            for (Sync rel : this.getOutgoingRelationships(Sync.class)) {
                Content syncedNode = (Content)rel.getTargetNode();
                PropertyMap map = new PropertyMap();
                map.put(content, this.getProperty((PropertyKey)content));
                map.put(contentType, this.getProperty((PropertyKey)contentType));
                map.put((PropertyKey)name, this.getProperty((PropertyKey)name));
                syncedNode.setProperties(securityContext, map);
            }
            Sync rel = (Sync)this.getIncomingRelationship(Sync.class);
            if (rel != null && (otherNode = (Content)rel.getSourceNode()) != null) {
                PropertyMap map = new PropertyMap();
                map.put(content, this.getProperty((PropertyKey)content));
                map.put(contentType, this.getProperty((PropertyKey)contentType));
                map.put((PropertyKey)name, this.getProperty((PropertyKey)name));
                otherNode.setProperties(otherNode.getSecurityContext(), map);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contentEquals(DOMNode otherNode) {
        if (otherNode instanceof Content) {
            String content1 = this.getTextContent();
            String content2 = ((Content)otherNode).getTextContent();
            if (content1 == null && content2 == null) {
                return true;
            }
            if (content1 != null && content2 != null) {
                return content1.equals(content2);
            }
        }
        return false;
    }

    @Override
    public String getContextName() {
        return "#text";
    }

    @Override
    public void updateFromNode(DOMNode newNode) throws FrameworkException {
        if (newNode instanceof Content) {
            this.setProperties(this.securityContext, new PropertyMap(content, newNode.getProperty((PropertyKey)content)));
        }
    }

    @Override
    public String getIdHash() {
        DOMNode _parent = (DOMNode)this.getProperty((PropertyKey)DOMNode.parent);
        if (_parent != null) {
            String dataHash = (String)_parent.getProperty((PropertyKey)DOMNode.dataHashProperty);
            if (dataHash == null) {
                dataHash = _parent.getIdHash();
            }
            return dataHash + "Content" + this.treeGetChildPosition(this);
        }
        return super.getIdHash();
    }

    @Override
    public void renderContent(RenderContext renderContext, int depth) throws FrameworkException {
        try {
            DOMNode _parent;
            Adapter<String, String> converter;
            RenderContext.EditMode edit = renderContext.getEditMode(this.securityContext.getUser(false));
            if (RenderContext.EditMode.DEPLOYMENT.equals((Object)edit)) {
                AsyncBuffer buf = renderContext.getBuffer();
                this.renderDeploymentExportComments(buf, true);
                buf.append(Content.escapeForHtml((String)this.getProperty((PropertyKey)content)));
                return;
            }
            if (this.isDeleted() || this.isHidden() || !this.displayForLocale(renderContext) || !this.displayForConditions(renderContext)) {
                return;
            }
            String id = this.getUuid();
            boolean inBody = renderContext.inBody();
            AsyncBuffer out = renderContext.getBuffer();
            String _contentType = (String)this.getProperty((PropertyKey)contentType);
            String _sharedComponentConfiguration = (String)this.getProperty((PropertyKey)sharedComponentConfiguration);
            if (StringUtils.isNotBlank((CharSequence)_sharedComponentConfiguration)) {
                Scripting.evaluate((ActionContext)renderContext, (GraphObject)this, (String)("${" + _sharedComponentConfiguration + "}"), (String)"shared component configuration");
            }
            String _content = this.getPropertyWithVariableReplacement(renderContext, (PropertyKey)content);
            if (!(RenderContext.EditMode.RAW.equals((Object)edit) || RenderContext.EditMode.WIDGET.equals((Object)edit) || _contentType != null && !"text/plain".equals(_contentType))) {
                _content = Content.escapeForHtml(_content);
            }
            if (RenderContext.EditMode.CONTENT.equals((Object)edit) && inBody && this.isGranted(Permission.write, this.securityContext)) {
                if ("text/javascript".equals(_contentType)) {
                    out.append("// data-structr-type='").append(this.getType()).append("'\n// data-structr-id='").append(id).append("'\n");
                } else if ("text/css".equals(_contentType)) {
                    out.append("/* data-structr-type='").append(this.getType()).append("'*/\n/* data-structr-id='").append(id).append("'*/\n");
                } else {
                    String cleanedContent = StringUtils.remove((String)StringUtils.remove((String)StringUtils.replace((String)((String)this.getProperty((PropertyKey)content)), (String)"\n", (String)"\\\\n"), (String)"<!--"), (String)"-->");
                    out.append("<!--data-structr-id=\"".concat(id).concat("\" data-structr-raw-value=\"").concat(Content.escapeForHtmlAttributes(cleanedContent)).concat("\"-->"));
                }
            }
            if (_contentType != null && (converter = contentConverters.get(_contentType)) != null) {
                try {
                    _content = (String)converter.adapt((Object)_content);
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to convert content: {}", (Object)fex.getMessage());
                }
            }
            if (!(_contentType != null && !_contentType.equals("text/plain") || _content == null || _content.isEmpty() || (_parent = (DOMNode)this.getProperty((PropertyKey)parent)) != null && _parent instanceof Textarea)) {
                _content = _content.replaceAll("[\\n]{1}", "<br>");
            }
            if (_content != null) {
                if (RenderContext.EditMode.CONTENT.equals((Object)edit) && _content.length() == 0) {
                    _content = "--- empty ---";
                }
                out.append(_content);
            }
            if (RenderContext.EditMode.CONTENT.equals((Object)edit) && inBody && !"text/javascript".equals(this.getProperty((PropertyKey)contentType)) && !"text/css".equals(this.getProperty((PropertyKey)contentType))) {
                out.append("<!---->");
            }
        }
        catch (Throwable t) {
            logger.error("", t);
        }
    }

    @Override
    public boolean isSynced() {
        return false;
    }

    @Override
    public Text splitText(int offset) throws DOMException {
        this.checkWriteAccess();
        String text = (String)this.getProperty((PropertyKey)content);
        if (text != null) {
            int len = text.length();
            if (offset < 0 || offset > len) {
                throw new DOMException(1, "Index out of range.");
            }
            String firstPart = text.substring(0, offset);
            String secondPart = text.substring(offset);
            Document document = this.getOwnerDocument();
            org.w3c.dom.Node parent = this.getParentNode();
            if (document != null && parent != null) {
                try {
                    this.setProperties(this.securityContext, new PropertyMap(content, (Object)firstPart));
                    Text newNode = document.createTextNode(secondPart);
                    parent.appendChild(newNode);
                    return newNode;
                }
                catch (FrameworkException fex) {
                    throw new DOMException(11, fex.toString());
                }
            }
            throw new DOMException(11, "Cannot split text element without parent and/or owner document.");
        }
        throw new DOMException(1, "Index out of range.");
    }

    @Override
    public boolean isElementContentWhitespace() {
        this.checkReadAccess();
        String text = (String)this.getProperty((PropertyKey)content);
        if (text != null) {
            return !text.matches("[\\S]*");
        }
        return false;
    }

    @Override
    public String getWholeText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Text replaceWholeText(String string) throws DOMException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getData() throws DOMException {
        this.checkReadAccess();
        return (String)this.getProperty((PropertyKey)content);
    }

    @Override
    public void setData(String data) throws DOMException {
        this.checkWriteAccess();
        try {
            this.setProperties(this.securityContext, new PropertyMap(content, (Object)data));
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
    }

    @Override
    public int getLength() {
        String text = (String)this.getProperty((PropertyKey)content);
        if (text != null) {
            return text.length();
        }
        return 0;
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        this.checkReadAccess();
        String text = (String)this.getProperty((PropertyKey)content);
        if (text != null) {
            try {
                return text.substring(offset, offset + count);
            }
            catch (IndexOutOfBoundsException iobex) {
                throw new DOMException(1, "Index out of range.");
            }
        }
        return "";
    }

    @Override
    public void appendData(String data) throws DOMException {
        this.checkWriteAccess();
        try {
            String text = (String)this.getProperty((PropertyKey)content);
            this.setProperties(this.securityContext, new PropertyMap(content, (Object)text.concat(data)));
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
    }

    @Override
    public void insertData(int offset, String data) throws DOMException {
        this.checkWriteAccess();
        try {
            String text = (String)this.getProperty((PropertyKey)content);
            String leftPart = text.substring(0, offset);
            String rightPart = text.substring(offset);
            StringBuilder buf = new StringBuilder(text.length() + data.length() + 1);
            buf.append(leftPart);
            buf.append(data);
            buf.append(rightPart);
            this.setProperties(this.securityContext, new PropertyMap(content, (Object)buf.toString()));
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        this.checkWriteAccess();
        try {
            String text = (String)this.getProperty((PropertyKey)content);
            String leftPart = text.substring(0, offset);
            String rightPart = text.substring(offset + count);
            this.setProperties(this.securityContext, new PropertyMap(content, (Object)leftPart.concat(rightPart)));
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
    }

    @Override
    public void replaceData(int offset, int count, String data) throws DOMException {
        this.checkWriteAccess();
        try {
            String text = (String)this.getProperty((PropertyKey)content);
            String leftPart = text.substring(0, offset);
            String rightPart = text.substring(offset + count);
            StringBuilder buf = new StringBuilder(leftPart.length() + data.length() + rightPart.length());
            buf.append(leftPart);
            buf.append(data);
            buf.append(rightPart);
            this.setProperties(this.securityContext, new PropertyMap(content, (Object)buf.toString()));
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getData();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setData(textContent);
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public void setNodeValue(String data) throws DOMException {
        this.setData(data);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public org.w3c.dom.Node doImport(Page newPage) throws DOMException {
        return newPage.createTextNode(this.getData());
    }

    public String getContext() {
        return this.getPagePath();
    }

    public String getFavoriteContent() {
        return (String)this.getProperty((PropertyKey)content);
    }

    public String getFavoriteContentType() {
        return (String)this.getProperty((PropertyKey)contentType);
    }

    public void setFavoriteContent(String content) throws FrameworkException {
        this.setProperty((PropertyKey)Content.content, content);
    }

    static {
        contentConverters.put("text/markdown", new Adapter<String, String>(){

            public String adapt(String s) throws FrameworkException {
                if (s != null) {
                    Node document = ((FlexMarkProcessor)flexMarkProcessor.get()).parser.parse(s);
                    return ((FlexMarkProcessor)flexMarkProcessor.get()).renderer.render(document);
                }
                return "";
            }
        });
        contentConverters.put("text/textile", new Adapter<String, String>(){

            public String adapt(String s) throws FrameworkException {
                if (s != null) {
                    return ((MarkupParser)textileProcessor.get()).parseToHtml(s);
                }
                return "";
            }
        });
        contentConverters.put("text/mediawiki", new Adapter<String, String>(){

            public String adapt(String s) throws FrameworkException {
                if (s != null) {
                    return ((MarkupParser)mediaWikiProcessor.get()).parseToHtml(s);
                }
                return "";
            }
        });
        contentConverters.put("text/tracwiki", new Adapter<String, String>(){

            public String adapt(String s) throws FrameworkException {
                if (s != null) {
                    return ((MarkupParser)tracWikiProcessor.get()).parseToHtml(s);
                }
                return "";
            }
        });
        contentConverters.put("text/confluence", new Adapter<String, String>(){

            public String adapt(String s) throws FrameworkException {
                if (s != null) {
                    return ((MarkupParser)confluenceProcessor.get()).parseToHtml(s);
                }
                return "";
            }
        });
        contentConverters.put("text/asciidoc", new Adapter<String, String>(){

            public String adapt(String s) throws FrameworkException {
                if (s != null) {
                    return ((Asciidoctor)asciiDocProcessor.get()).render(s, new HashMap());
                }
                return "";
            }
        });
    }

    private static class FlexMarkProcessor {
        Parser parser;
        HtmlRenderer renderer;

        public FlexMarkProcessor(Parser parser, HtmlRenderer renderer) {
            this.parser = parser;
            this.renderer = renderer;
        }
    }

    private static class ThreadLocalAsciiDocProcessor
    extends ThreadLocal<Asciidoctor> {
        private ThreadLocalAsciiDocProcessor() {
        }

        @Override
        protected Asciidoctor initialValue() {
            return Asciidoctor.Factory.create();
        }
    }

    private static class ThreadLocalTracWikiProcessor
    extends ThreadLocal<MarkupParser> {
        private ThreadLocalTracWikiProcessor() {
        }

        @Override
        protected MarkupParser initialValue() {
            return new MarkupParser((Dialect)new TracWikiDialect());
        }
    }

    private static class ThreadLocalTextileProcessor
    extends ThreadLocal<MarkupParser> {
        private ThreadLocalTextileProcessor() {
        }

        @Override
        protected MarkupParser initialValue() {
            return new MarkupParser((Dialect)new TextileDialect());
        }
    }

    private static class ThreadLocalFlexMarkProcessor
    extends ThreadLocal<FlexMarkProcessor> {
        private ThreadLocalFlexMarkProcessor() {
        }

        @Override
        protected FlexMarkProcessor initialValue() {
            MutableDataSet options = new MutableDataSet();
            options.setAll(PegdownOptionsAdapter.flexmarkOptions((int)65535, (Extension[])new Extension[0]));
            Parser parser = Parser.builder((DataHolder)options).build();
            HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
            return new FlexMarkProcessor(parser, renderer);
        }
    }

    private static class ThreadLocalMediaWikiProcessor
    extends ThreadLocal<MarkupParser> {
        private ThreadLocalMediaWikiProcessor() {
        }

        @Override
        protected MarkupParser initialValue() {
            return new MarkupParser((Dialect)new MediaWikiDialect());
        }
    }

    private static class ThreadLocalConfluenceProcessor
    extends ThreadLocal<MarkupParser> {
        private ThreadLocalConfluenceProcessor() {
        }

        @Override
        protected MarkupParser initialValue() {
            return new MarkupParser((Dialect)new ConfluenceDialect());
        }
    }
}

