/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.dom;

import org.structr.web.entity.dom.DOMAdoptable;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMImportable;
import org.structr.web.entity.dom.Page;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DOMAttribute
implements Attr,
DOMImportable,
DOMAdoptable {
    private DOMElement parent = null;
    private boolean specified = false;
    private boolean isId = false;
    private String name = null;
    private String value = null;
    private Page page = null;

    public DOMAttribute(Page page, DOMElement parent, String name, String value) {
        this(page, parent, name, value, true, false);
    }

    public DOMAttribute(Page page, DOMElement parent, String name, String value, boolean specified, boolean isId) {
        this.page = page;
        this.specified = specified;
        this.isId = isId;
        this.parent = parent;
        this.name = name;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o instanceof DOMAttribute) {
            return ((DOMAttribute)o).hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.value;
    }

    @Override
    public void setNodeValue(String value) throws DOMException {
        this.value = value;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return null;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        String previousAttributeName;
        if (this.parent != null && (previousAttributeName = this.parent.getOffsetAttributeName(this.name, -1)) != null) {
            return this.parent.getAttributeNode(previousAttributeName);
        }
        return null;
    }

    @Override
    public Node getNextSibling() {
        String nextAttributeName;
        if (this.parent != null && (nextAttributeName = this.parent.getOffsetAttributeName(this.name, 1)) != null) {
            return this.parent.getAttributeNode(nextAttributeName);
        }
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.page;
    }

    @Override
    public Node insertBefore(Node node, Node node1) throws DOMException {
        return null;
    }

    @Override
    public Node replaceChild(Node node, Node node1) throws DOMException {
        return null;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        return null;
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node cloneNode(boolean bln) {
        return null;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string, String string1) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return this.parent.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return this.getNodeName();
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.value;
    }

    @Override
    public void setTextContent(String text) throws DOMException {
        this.value = text;
    }

    @Override
    public boolean isSameNode(Node node) {
        return this.getNodeName().equals(node.getNodeName());
    }

    @Override
    public String lookupPrefix(String string) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return true;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node node) {
        return this.equals(node);
    }

    @Override
    public Object getFeature(String string, String string1) {
        return null;
    }

    @Override
    public Object setUserData(String string, Object o, UserDataHandler udh) {
        return null;
    }

    @Override
    public Object getUserData(String string) {
        return null;
    }

    @Override
    public String getName() {
        return this.getNodeName();
    }

    @Override
    public boolean getSpecified() {
        return this.specified;
    }

    @Override
    public String getValue() {
        return this.getNodeValue();
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.setNodeValue(value);
    }

    @Override
    public Element getOwnerElement() {
        return this.parent;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    public void setParent(DOMElement parent) {
        this.parent = parent;
    }

    @Override
    public Node doAdopt(Page _page) throws DOMException {
        this.page = _page;
        return this;
    }

    @Override
    public Node doImport(Page newPage) throws DOMException {
        Attr newAttr = newPage.createAttribute(this.name);
        newAttr.setValue(this.value);
        return newAttr;
    }
}

