/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.core.script.Scripting;
import org.structr.schema.NonIndexed;
import org.structr.schema.action.ActionContext;
import org.structr.web.common.AsyncBuffer;
import org.structr.web.common.HtmlProperty;
import org.structr.web.common.RenderContext;
import org.structr.web.entity.dom.DOMAttribute;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.DOMNodeList;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.structr.web.entity.html.Body;
import org.structr.web.entity.relation.PageLink;
import org.structr.web.entity.relation.Sync;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class DOMElement
extends DOMNode
implements Element,
NamedNodeMap,
NonIndexed {
    private static final Logger logger = LoggerFactory.getLogger((String)DOMElement.class.getName());
    private static final int HtmlPrefixLength = "_html_".length();
    private static final String STRUCTR_ACTION_PROPERTY = "data-structr-action";
    private static final Map<String, HtmlProperty> htmlProperties = new LRUMap(1000);
    private static final String lowercaseBodyName = Body.class.getSimpleName().toLowerCase();
    public static final Property<String> tag = new StringProperty("tag").indexed();
    public static final Property<String> path = new StringProperty("path").indexed();
    public static final Property<String> partialUpdateKey = new StringProperty("partialUpdateKey").indexed();
    public static final Property<String> _onabort = new HtmlProperty("onabort");
    public static final Property<String> _onblur = new HtmlProperty("onblur");
    public static final Property<String> _oncanplay = new HtmlProperty("oncanplay");
    public static final Property<String> _oncanplaythrough = new HtmlProperty("oncanplaythrough");
    public static final Property<String> _onchange = new HtmlProperty("onchange");
    public static final Property<String> _onclick = new HtmlProperty("onclick");
    public static final Property<String> _oncontextmenu = new HtmlProperty("oncontextmenu");
    public static final Property<String> _ondblclick = new HtmlProperty("ondblclick");
    public static final Property<String> _ondrag = new HtmlProperty("ondrag");
    public static final Property<String> _ondragend = new HtmlProperty("ondragend");
    public static final Property<String> _ondragenter = new HtmlProperty("ondragenter");
    public static final Property<String> _ondragleave = new HtmlProperty("ondragleave");
    public static final Property<String> _ondragover = new HtmlProperty("ondragover");
    public static final Property<String> _ondragstart = new HtmlProperty("ondragstart");
    public static final Property<String> _ondrop = new HtmlProperty("ondrop");
    public static final Property<String> _ondurationchange = new HtmlProperty("ondurationchange");
    public static final Property<String> _onemptied = new HtmlProperty("onemptied");
    public static final Property<String> _onended = new HtmlProperty("onended");
    public static final Property<String> _onerror = new HtmlProperty("onerror");
    public static final Property<String> _onfocus = new HtmlProperty("onfocus");
    public static final Property<String> _oninput = new HtmlProperty("oninput");
    public static final Property<String> _oninvalid = new HtmlProperty("oninvalid");
    public static final Property<String> _onkeydown = new HtmlProperty("onkeydown");
    public static final Property<String> _onkeypress = new HtmlProperty("onkeypress");
    public static final Property<String> _onkeyup = new HtmlProperty("onkeyup");
    public static final Property<String> _onload = new HtmlProperty("onload");
    public static final Property<String> _onloadeddata = new HtmlProperty("onloadeddata");
    public static final Property<String> _onloadedmetadata = new HtmlProperty("onloadedmetadata");
    public static final Property<String> _onloadstart = new HtmlProperty("onloadstart");
    public static final Property<String> _onmousedown = new HtmlProperty("onmousedown");
    public static final Property<String> _onmousemove = new HtmlProperty("onmousemove");
    public static final Property<String> _onmouseout = new HtmlProperty("onmouseout");
    public static final Property<String> _onmouseover = new HtmlProperty("onmouseover");
    public static final Property<String> _onmouseup = new HtmlProperty("onmouseup");
    public static final Property<String> _onmousewheel = new HtmlProperty("onmousewheel");
    public static final Property<String> _onpause = new HtmlProperty("onpause");
    public static final Property<String> _onplay = new HtmlProperty("onplay");
    public static final Property<String> _onplaying = new HtmlProperty("onplaying");
    public static final Property<String> _onprogress = new HtmlProperty("onprogress");
    public static final Property<String> _onratechange = new HtmlProperty("onratechange");
    public static final Property<String> _onreadystatechange = new HtmlProperty("onreadystatechange");
    public static final Property<String> _onreset = new HtmlProperty("onreset");
    public static final Property<String> _onscroll = new HtmlProperty("onscroll");
    public static final Property<String> _onseeked = new HtmlProperty("onseeked");
    public static final Property<String> _onseeking = new HtmlProperty("onseeking");
    public static final Property<String> _onselect = new HtmlProperty("onselect");
    public static final Property<String> _onshow = new HtmlProperty("onshow");
    public static final Property<String> _onstalled = new HtmlProperty("onstalled");
    public static final Property<String> _onsubmit = new HtmlProperty("onsubmit");
    public static final Property<String> _onsuspend = new HtmlProperty("onsuspend");
    public static final Property<String> _ontimeupdate = new HtmlProperty("ontimeupdate");
    public static final Property<String> _onvolumechange = new HtmlProperty("onvolumechange");
    public static final Property<String> _onwaiting = new HtmlProperty("onwaiting");
    public static final Property<String> _data = new HtmlProperty("data").indexed();
    public static final Property<Boolean> _reload = new BooleanProperty("data-structr-reload");
    public static final Property<Boolean> _confirm = new BooleanProperty("data-structr-confirm");
    public static final Property<String> _action = new StringProperty("data-structr-action");
    public static final Property<String> _attributes = new StringProperty("data-structr-attributes");
    public static final Property<String> _attr = new StringProperty("data-structr-attr");
    public static final Property<String> _fieldName = new StringProperty("data-structr-name");
    public static final Property<String> _hide = new StringProperty("data-structr-hide");
    public static final Property<String> _rawValue = new StringProperty("data-structr-raw-value");
    public static final Property<String> _accesskey = new HtmlProperty("accesskey").indexed();
    public static final Property<String> _class = new HtmlProperty("class").indexed();
    public static final Property<String> _contenteditable = new HtmlProperty("contenteditable");
    public static final Property<String> _contextmenu = new HtmlProperty("contextmenu");
    public static final Property<String> _dir = new HtmlProperty("dir");
    public static final Property<String> _draggable = new HtmlProperty("draggable");
    public static final Property<String> _dropzone = new HtmlProperty("dropzone");
    public static final Property<String> _hidden = new HtmlProperty("hidden");
    public static final Property<String> _id = new HtmlProperty("id");
    public static final Property<String> _lang = new HtmlProperty("lang");
    public static final Property<String> _spellcheck = new HtmlProperty("spellcheck");
    public static final Property<String> _style = new HtmlProperty("style");
    public static final Property<String> _tabindex = new HtmlProperty("tabindex");
    public static final Property<String> _title = new HtmlProperty("title").indexed();
    public static final Property<String> _translate = new HtmlProperty("translate");
    public static final Property<String> _is = new HtmlProperty("is");
    public static final Property<String> _properties = new HtmlProperty("properties");
    public static final Property<String> _role = new HtmlProperty("role");
    public static final View publicView = new View(DOMElement.class, "public", new Property[]{name, tag, pageId, path, parent, children, restQuery, cypherQuery, xpathQuery, functionQuery, partialUpdateKey, dataKey, syncedNodes, sharedComponent, isDOMNode});
    public static final View uiView = new View(DOMElement.class, "ui", new Property[]{name, tag, pageId, path, parent, children, childrenIds, owner, restQuery, cypherQuery, xpathQuery, functionQuery, partialUpdateKey, dataKey, syncedNodes, sharedComponent, sharedComponentConfiguration, isDOMNode, renderDetails, hideOnIndex, hideOnDetail, showForLocales, hideForLocales, showConditions, hideConditions, _reload, _confirm, _action, _attributes, _attr, _fieldName, _hide, _rawValue, _class, _id});
    public static final View htmlView = new View(DOMElement.class, "_html_", new Property[]{_accesskey, _class, _contenteditable, _contextmenu, _dir, _draggable, _dropzone, _hidden, _id, _lang, _spellcheck, _style, _tabindex, _title, _translate, _onabort, _onblur, _oncanplay, _oncanplaythrough, _onchange, _onclick, _oncontextmenu, _ondblclick, _ondrag, _ondragend, _ondragenter, _ondragleave, _ondragover, _ondragstart, _ondrop, _ondurationchange, _onemptied, _onended, _onerror, _onfocus, _oninput, _oninvalid, _onkeydown, _onkeypress, _onkeyup, _onload, _onloadeddata, _onloadedmetadata, _onloadstart, _onmousedown, _onmousemove, _onmouseout, _onmouseover, _onmouseup, _onmousewheel, _onpause, _onplay, _onplaying, _onprogress, _onratechange, _onreadystatechange, _onreset, _onscroll, _onseeked, _onseeking, _onselect, _onshow, _onstalled, _onsubmit, _onsuspend, _ontimeupdate, _onvolumechange, _onwaiting, _role});

    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        valid &= this.nonEmpty(tag, errorBuffer);
        return valid &= ValidationHelper.isValidStringMatchingRegex((GraphObject)this, tag, (String)"^[a-zA-Z0-9]+$", (ErrorBuffer)errorBuffer);
    }

    @Override
    public boolean contentEquals(DOMNode otherNode) {
        return false;
    }

    @Override
    public String getContextName() {
        String _name = (String)this.getProperty((PropertyKey)name);
        if (_name != null) {
            return _name;
        }
        return (String)this.getProperty((PropertyKey)tag);
    }

    @Override
    public void updateFromNode(DOMNode newNode) throws FrameworkException {
        if (newNode instanceof DOMElement) {
            PropertyMap properties = new PropertyMap();
            for (Property htmlProp : this.getHtmlAttributes()) {
                properties.put((PropertyKey)htmlProp, newNode.getProperty((PropertyKey)htmlProp));
            }
            properties.put(tag, newNode.getProperty((PropertyKey)tag));
            this.setProperties(this.securityContext, properties);
        }
    }

    public Property[] getHtmlAttributes() {
        return htmlView.properties();
    }

    public void openingTag(AsyncBuffer out, String tag, RenderContext.EditMode editMode, RenderContext renderContext, int depth) throws FrameworkException {
        DOMElement _syncedNode = (DOMElement)this.getProperty((PropertyKey)sharedComponent);
        if (_syncedNode != null && RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode)) {
            String name = (String)_syncedNode.getProperty((PropertyKey)AbstractNode.name);
            out.append("<structr:component src=\"");
            out.append(name != null ? name : _syncedNode.getUuid());
            out.append("\"");
            this.renderSharedComponentConfiguration(out, editMode);
            this.renderCustomAttributes(out, this.securityContext, renderContext);
        } else {
            out.append("<").append(tag);
            for (PropertyKey attribute : StructrApp.getConfiguration().getPropertySet(this.entityType, "_html_")) {
                String value = null;
                value = RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) ? (String)this.getProperty(attribute) : this.getPropertyWithVariableReplacement(renderContext, attribute);
                if (!RenderContext.EditMode.RAW.equals((Object)editMode) && !RenderContext.EditMode.WIDGET.equals((Object)editMode)) {
                    value = DOMElement.escapeForHtmlAttributes(value);
                }
                if (value == null) continue;
                String key = attribute.jsonName().substring("_html_".length());
                out.append(" ").append(key).append("=\"").append(value).append("\"");
            }
            this.renderSharedComponentConfiguration(out, editMode);
            this.renderCustomAttributes(out, this.securityContext, renderContext);
            switch (editMode) {
                case CONTENT: {
                    String pageId;
                    if (depth == 0 && (pageId = renderContext.getPageId()) != null) {
                        out.append(" data-structr-page=\"").append(pageId).append("\"");
                    }
                    out.append(" data-structr-id=\"").append(this.getUuid()).append("\"");
                    break;
                }
                case RAW: {
                    out.append(" ").append(dataHashProperty.jsonName()).append("=\"").append(this.getIdHash()).append("\"");
                }
            }
        }
        out.append(">");
    }

    @Override
    public void renderContent(RenderContext renderContext, int depth) throws FrameworkException {
        if (this.isDeleted() || this.isHidden() || !this.displayForLocale(renderContext) || !this.displayForConditions(renderContext)) {
            return;
        }
        AsyncBuffer out = renderContext.getBuffer();
        RenderContext.EditMode editMode = renderContext.getEditMode(this.securityContext.getUser(false));
        boolean isVoid = this.isVoidElement();
        String _tag = (String)this.getProperty((PropertyKey)tag);
        Result localResult = renderContext.getResult();
        boolean anyChildNodeCreatesNewLine = false;
        this.renderStructrAppLib(out, this.securityContext, renderContext, depth);
        if (depth > 0 && !this.avoidWhitespace()) {
            out.append(DOMElement.indent(depth, renderContext));
        }
        if (StringUtils.isNotBlank((CharSequence)_tag)) {
            if (RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) && this.renderDeploymentExportComments(out, false) && depth > 0 && !this.avoidWhitespace()) {
                out.append(DOMElement.indent(depth, renderContext));
            }
            this.openingTag(out, _tag, editMode, renderContext, depth);
            try {
                if (lowercaseBodyName.equals(this.getTagName())) {
                    renderContext.setInBody(true);
                }
                if (this.getProperty((PropertyKey)sharedComponent) == null || !RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode)) {
                    String _sharedComponentConfiguration;
                    DOMElement _syncedNode;
                    List<DOMChildren> rels = this.getChildRelationships();
                    if (rels.isEmpty() && (_syncedNode = (DOMElement)this.getProperty((PropertyKey)sharedComponent)) != null) {
                        rels.addAll(_syncedNode.getChildRelationships());
                    }
                    if (StringUtils.isNotBlank((CharSequence)(_sharedComponentConfiguration = (String)this.getProperty((PropertyKey)sharedComponentConfiguration)))) {
                        Scripting.evaluate((ActionContext)renderContext, (GraphObject)this, (String)("${" + _sharedComponentConfiguration + "}"), (String)"shared component configuration");
                    }
                    for (AbstractRelationship abstractRelationship : rels) {
                        DOMNode subNode = (DOMNode)abstractRelationship.getTargetNode();
                        if (subNode instanceof DOMElement) {
                            anyChildNodeCreatesNewLine = anyChildNodeCreatesNewLine || !subNode.avoidWhitespace();
                        }
                        subNode.render(renderContext, depth + 1);
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Error while rendering node {}: {}", new Object[]{this.getUuid(), t});
                out.append("Error while rendering node ").append(this.getUuid()).append(": ").append(t.getMessage());
                logger.warn("", t);
            }
            if (StringUtils.isNotBlank((CharSequence)_tag) && !isVoid) {
                boolean isTemplate;
                DOMElement _syncedNode = (DOMElement)this.getProperty((PropertyKey)sharedComponent);
                boolean bl = isTemplate = _syncedNode != null && RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode);
                if (anyChildNodeCreatesNewLine || isTemplate) {
                    out.append(DOMElement.indent(depth, renderContext));
                }
                if (_syncedNode != null && RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode)) {
                    out.append("</structr:component>");
                } else if (isTemplate) {
                    out.append("</structr:template>");
                } else {
                    out.append("</").append(_tag).append(">");
                }
            }
        }
        if (localResult != null) {
            renderContext.setResult(localResult);
        }
    }

    public boolean isVoidElement() {
        return false;
    }

    public String getOffsetAttributeName(String name, int offset) {
        int namePosition = -1;
        int index = 0;
        List keys = Iterables.toList((Iterable)this.getNode().getPropertyKeys());
        Collections.sort(keys);
        ArrayList<String> names = new ArrayList<String>(10);
        for (String key : keys) {
            if (!key.startsWith("_html_")) continue;
            String htmlName = key.substring(HtmlPrefixLength);
            if (name.equals(htmlName)) {
                namePosition = index;
            }
            names.add(htmlName);
            ++index;
        }
        int offsetIndex = namePosition + offset;
        if (offsetIndex >= 0 && offsetIndex < names.size()) {
            return (String)names.get(offsetIndex);
        }
        return null;
    }

    public List<String> getHtmlAttributeNames() {
        ArrayList<String> names = new ArrayList<String>(10);
        for (String key : this.getNode().getPropertyKeys()) {
            if (!key.startsWith("_html_")) continue;
            names.add(key.substring(HtmlPrefixLength));
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HtmlProperty findOrCreateAttributeKey(String name) {
        HtmlProperty htmlProperty = null;
        Map<String, HtmlProperty> map = htmlProperties;
        synchronized (map) {
            htmlProperty = htmlProperties.get(name);
        }
        if (htmlProperty == null) {
            PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(this.entityType, name, false);
            if (key != null && key instanceof HtmlProperty) {
                htmlProperty = (HtmlProperty)key;
            } else {
                htmlProperty = new HtmlProperty(name);
                htmlProperty.setDeclaringClass(DOMElement.class);
            }
            Map<String, HtmlProperty> map2 = htmlProperties;
            synchronized (map2) {
                htmlProperties.put(name, htmlProperty);
            }
        }
        return htmlProperty;
    }

    @Override
    public String getTagName() {
        return (String)this.getProperty((PropertyKey)tag);
    }

    @Override
    public String getAttribute(String name) {
        HtmlProperty htmlProperty = this.findOrCreateAttributeKey(name);
        return (String)htmlProperty.getProperty(this.securityContext, (GraphObject)this, true);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        try {
            HtmlProperty htmlProperty = this.findOrCreateAttributeKey(name);
            if (htmlProperty != null) {
                htmlProperty.setProperty(this.securityContext, (GraphObject)this, value);
            }
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.getMessage());
        }
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        try {
            HtmlProperty htmlProperty = this.findOrCreateAttributeKey(name);
            if (htmlProperty != null) {
                htmlProperty.setProperty(this.securityContext, (GraphObject)this, null);
            }
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.getMessage());
        }
    }

    @Override
    public Attr getAttributeNode(String name) {
        HtmlProperty htmlProperty = this.findOrCreateAttributeKey(name);
        String value = (String)htmlProperty.getProperty(this.securityContext, (GraphObject)this, true);
        if (value != null) {
            boolean explicitlySpecified = true;
            boolean isId = false;
            if (value.equals(htmlProperty.defaultValue())) {
                explicitlySpecified = false;
            }
            return new DOMAttribute((Page)this.getOwnerDocument(), this, name, value, explicitlySpecified, isId);
        }
        return null;
    }

    @Override
    public Attr setAttributeNode(Attr attr) throws DOMException {
        Attr attribute = this.getAttributeNode(attr.getName());
        this.setAttribute(attr.getName(), attr.getValue());
        if (attr instanceof DOMAttribute) {
            ((DOMAttribute)attr).setParent(this);
        }
        return attribute;
    }

    @Override
    public Attr removeAttributeNode(Attr attr) throws DOMException {
        Attr attribute = this.getAttributeNode(attr.getName());
        this.setAttribute(attr.getName(), null);
        return attribute;
    }

    @Override
    public NodeList getElementsByTagName(String tagName) {
        DOMNodeList results = new DOMNodeList();
        this.collectNodesByPredicate(this, results, new DOMNode.TagPredicate(tagName), 0, false);
        return results;
    }

    @Override
    public String getAttributeNS(String string, String string1) throws DOMException {
        return null;
    }

    @Override
    public void setAttributeNS(String string, String string1, String string2) throws DOMException {
    }

    @Override
    public void removeAttributeNS(String string, String string1) throws DOMException {
    }

    @Override
    public Attr getAttributeNodeNS(String string, String string1) throws DOMException {
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string1) throws DOMException {
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String string, String string1) throws DOMException {
        return false;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public void setIdAttribute(String idString, boolean isId) throws DOMException {
        this.checkWriteAccess();
        try {
            this.setProperties(this.securityContext, new PropertyMap(_id, (Object)idString));
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
    }

    @Override
    public void setIdAttributeNS(String string, String string1, boolean bln) throws DOMException {
        throw new UnsupportedOperationException("Namespaces not supported.");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new UnsupportedOperationException("Attribute nodes not supported in HTML5.");
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this;
    }

    @Override
    public boolean hasAttributes() {
        return this.getLength() > 0;
    }

    @Override
    public Node getNamedItem(String name) {
        return this.getAttributeNode(name);
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        if (node instanceof Attr) {
            return this.setAttributeNode((Attr)node);
        }
        return null;
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        Attr attribute = this.getAttributeNode(name);
        this.setAttribute(name, null);
        return attribute;
    }

    @Override
    public Node item(int i) {
        List<String> htmlAttributeNames = this.getHtmlAttributeNames();
        if (i >= 0 && i < htmlAttributeNames.size()) {
            return this.getAttributeNode(htmlAttributeNames.get(i));
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.getHtmlAttributeNames().size();
    }

    @Override
    public Node getNamedItemNS(String string, String string1) throws DOMException {
        return null;
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        return null;
    }

    @Override
    public Node removeNamedItemNS(String string, String string1) throws DOMException {
        return null;
    }

    @Override
    public Node doImport(Page newPage) throws DOMException {
        DOMElement newElement = (DOMElement)newPage.createElement(this.getTagName());
        for (String _name : this.getHtmlAttributeNames()) {
            Attr attr = this.getAttributeNode(_name);
            if (!attr.getSpecified()) continue;
            newElement.setAttribute(attr.getName(), attr.getValue());
        }
        return newElement;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            DOMElement otherNode;
            PropertyMap map = new PropertyMap();
            for (Sync rel : this.getOutgoingRelationships(Sync.class)) {
                DOMElement syncedNode = (DOMElement)rel.getTargetNode();
                map.clear();
                Property[] propertyArray = syncedNode.getHtmlAttributes();
                int n = propertyArray.length;
                for (int i = 0; i < n; ++i) {
                    Property htmlProp = propertyArray[i];
                    map.put((PropertyKey)htmlProp, this.getProperty((PropertyKey)htmlProp));
                }
                map.put((PropertyKey)name, this.getProperty((PropertyKey)name));
                syncedNode.setProperties(securityContext, map);
            }
            Sync rel = (Sync)this.getIncomingRelationship(Sync.class);
            if (rel != null && (otherNode = (DOMElement)rel.getSourceNode()) != null) {
                map.clear();
                for (Property htmlProp : otherNode.getHtmlAttributes()) {
                    map.put((PropertyKey)htmlProp, this.getProperty((PropertyKey)htmlProp));
                }
                map.put((PropertyKey)name, this.getProperty((PropertyKey)name));
                otherNode.setProperties(securityContext, map);
            }
            return true;
        }
        return false;
    }

    private void renderStructrAppLib(AsyncBuffer out, SecurityContext securityContext, RenderContext renderContext, int depth) throws FrameworkException {
        RenderContext.EditMode editMode = renderContext.getEditMode(securityContext.getUser(false));
        if (!(RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) || RenderContext.EditMode.RAW.equals((Object)editMode) || RenderContext.EditMode.WIDGET.equals((Object)editMode) || renderContext.appLibRendered() || this.getProperty((PropertyKey)new StringProperty(STRUCTR_ACTION_PROPERTY)) == null)) {
            out.append(DOMElement.indent(depth, renderContext)).append("<script>if (!window.jQuery) { document.write('<script src=\"/structr/js/lib/jquery-1.11.1.min.js\"><\\/script>'); }</script>").append(DOMElement.indent(depth, renderContext)).append("<script>if (!window.jQuery.ui) { document.write('<script src=\"/structr/js/lib/jquery-ui-1.11.0.custom.min.js\"><\\/script>'); }</script>").append(DOMElement.indent(depth, renderContext)).append("<script>if (!window.jQuery.ui.timepicker) { document.write('<script src=\"/structr/js/lib/jquery-ui-timepicker-addon.min.js\"><\\/script>'); }</script>").append(DOMElement.indent(depth, renderContext)).append("<script>if (!window.StructrApp) { document.write('<script src=\"/structr/js/structr-app.js\"><\\/script>'); }</script>").append(DOMElement.indent(depth, renderContext)).append("<script>if (!window.moment) { document.write('<script src=\"/structr/js/lib/moment.min.js\"><\\/script>'); }</script>").append(DOMElement.indent(depth, renderContext)).append("<link rel=\"stylesheet\" type=\"text/css\" href=\"/structr/css/lib/jquery-ui-1.10.3.custom.min.css\">");
            renderContext.setAppLibRendered(true);
        }
    }

    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        LinkedList<PropertyKey> allProperties = new LinkedList<PropertyKey>();
        Iterable htmlAttrs = super.getPropertyKeys(propertyView);
        for (PropertyKey attr : htmlAttrs) {
            allProperties.add(attr);
        }
        allProperties.addAll(this.getDataPropertyKeys());
        return allProperties;
    }

    @Override
    public boolean isSynced() {
        return this.hasIncomingRelationships(Sync.class) || this.hasOutgoingRelationships(Sync.class);
    }

    @Override
    public List<GraphObject> getSyncData() throws FrameworkException {
        List<GraphObject> data = super.getSyncData();
        data.add((GraphObject)this.getProperty((PropertyKey)sharedComponent));
        data.add((GraphObject)this.getIncomingRelationship(Sync.class));
        if (this.isSynced()) {
            data.add((GraphObject)this.getProperty((PropertyKey)ownerDocument));
            data.add((GraphObject)this.getOutgoingRelationship(PageLink.class));
        }
        return data;
    }
}

