/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.io.File;
import java.io.IOException;
import org.python.google.common.io.Files;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;

public class CopyFileContentsFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_POST = "Usage: ${ copy_file_contents(file1_uuid,file2_uuid) }. Example: ${ copy_file_contents('abcdefgh123','ijklmnop456') }";
    public static final String ERROR_MESSAGE_POST_JS = "Usage: ${{ Structr.copy_file_contentscreate_deep_file_copy(file1_uuid,file2_uuid) }}. Example: ${{ Structr.copy_file_contents('abcdefgh123','ijklmnop456') }}";

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 2)) {
            Object toCopy = sources[0];
            Object toBeReplaced = sources[1];
            if (toCopy instanceof FileBase && toBeReplaced instanceof FileBase) {
                FileBase nodeToCopy = (FileBase)toCopy;
                FileBase nodeToBeReplaced = (FileBase)toBeReplaced;
                try {
                    File fileToCopy = nodeToCopy.getFileOnDisk();
                    if (!fileToCopy.exists()) {
                        logger.warn("Error: Given source file does not exist. Parameters: {}", (Object)this.getParametersAsString(sources));
                        return "Error: Given source file does not exist.";
                    }
                    File fileToBeReplaced = nodeToBeReplaced.getFileOnDisk();
                    if (!fileToBeReplaced.exists()) {
                        nodeToBeReplaced.afterCreation(nodeToBeReplaced.getSecurityContext());
                    }
                    Files.copy((File)fileToCopy, (File)fileToBeReplaced);
                    PropertyMap changedProperties = new PropertyMap();
                    changedProperties.put(FileBase.checksum, (Object)FileHelper.getChecksum(fileToBeReplaced));
                    changedProperties.put(FileBase.version, (Object)0);
                    changedProperties.put((PropertyKey)new StringProperty("contentType"), nodeToCopy.getProperty((PropertyKey)new StringProperty("contentType")));
                    long fileSize = FileHelper.getSize(nodeToBeReplaced);
                    if (fileSize > 0L) {
                        changedProperties.put(FileBase.size, (Object)fileSize);
                    }
                    nodeToBeReplaced.unlockSystemPropertiesOnce();
                    nodeToBeReplaced.setProperties(nodeToBeReplaced.getSecurityContext(), changedProperties);
                    return nodeToBeReplaced;
                }
                catch (IOException | FrameworkException ex) {
                    logger.error("Error: Could not copy file due to exception.", ex);
                    return "Error: Could not copy file due to exception.";
                }
            }
            logger.warn("Error: entities are not instances of File. Parameters: {}", (Object)this.getParametersAsString(sources));
            return "Error: entities are not nodes.";
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_POST_JS : ERROR_MESSAGE_POST;
    }

    public String shortDescription() {
        return "Creates a copy of the file content linked to the given FileBase entity and links it to the other FileBase entity.";
    }

    public String getName() {
        return "copy_file_contents()";
    }
}

