/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.web.entity.dom.DOMNode;

public class EscapeHtmlFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ESCAPE_HTML = "Usage: ${escape_html(text)}. Example: ${escape_html(\"test & test\")}";
    public static final String ERROR_MESSAGE_ESCAPE_HTML_JS = "Usage: ${{Structr.escape_html(text)}}. Example: ${{Structr.escape_html(\"test & test\")}}";

    public String getName() {
        return "escape_html()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            return DOMNode.escapeForHtmlAttributes(sources[0].toString());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_ESCAPE_HTML_JS : ERROR_MESSAGE_ESCAPE_HTML;
    }

    public String shortDescription() {
        return "";
    }
}

