/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.property.IntProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.rest.common.HttpHelper;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.web.function.FromJsonFunction;

public class HttpPostFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_POST = "Usage: ${POST(URL, body [, contentType, charset])}. Example: ${POST('http://localhost:8082/structr/rest/folders', '{name:Test}', 'application/json', 'utf-8')}";
    public static final String ERROR_MESSAGE_POST_JS = "Usage: ${{Structr.POST(URL, body [, contentType, charset])}}. Example: ${{Structr.POST('http://localhost:8082/structr/rest/folders', '{name:\"Test\"}', 'application/json', 'utf-8')}}";

    public String getName() {
        return "POST()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 2)) {
            String uri = sources[0].toString();
            String body = sources[1].toString();
            String contentType = "application/json";
            String charset = "utf-8";
            if (sources.length >= 3 && sources[2] != null) {
                contentType = sources[2].toString();
            }
            if (sources.length >= 4 && sources[3] != null) {
                charset = sources[3].toString();
            }
            Map responseData = HttpHelper.post((String)uri, (String)body, null, null, (Map)ctx.getHeaders());
            int statusCode = Integer.parseInt((String)responseData.get("status"));
            responseData.remove("status");
            String responseBody = (String)responseData.get("body");
            responseData.remove("body");
            GraphObjectMap response = new GraphObjectMap();
            if ("application/json".equals(contentType)) {
                FromJsonFunction fromJsonFunction = new FromJsonFunction();
                response.setProperty((PropertyKey)new StringProperty("body"), fromJsonFunction.apply(ctx, caller, new Object[]{responseBody}));
            } else {
                response.setProperty((PropertyKey)new StringProperty("body"), (Object)responseBody);
            }
            response.setProperty((PropertyKey)new IntProperty("status"), (Object)statusCode);
            GraphObjectMap map = new GraphObjectMap();
            for (Map.Entry entry : responseData.entrySet()) {
                map.put((PropertyKey)new StringProperty((String)entry.getKey()), entry.getValue());
            }
            response.setProperty((PropertyKey)new StringProperty("headers"), (Object)map);
            return response;
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_POST_JS : ERROR_MESSAGE_POST;
    }

    public String shortDescription() {
        return "Sends an HTTP POST request to the given URL and returns the response body";
    }
}

