/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.util.Locale;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class IsLocaleFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_IS_LOCALE = "Usage: ${is_locale(locales...)}";
    public static final String ERROR_MESSAGE_IS_LOCALE_JS = "Usage: ${{Structr.isLocale(locales...}}. Example ${{Structr.isLocale('de_DE', 'de_AT', 'de_CH')}}";

    public String getName() {
        return "is_locale()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        Locale locale = ctx.getLocale();
        if (locale != null) {
            String localeString = locale.toString();
            if (sources != null && sources.length > 0) {
                int len = sources.length;
                for (int i = 0; i < len; ++i) {
                    if (!localeString.equals(sources[i].toString())) continue;
                    return true;
                }
            } else {
                this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            }
        }
        return false;
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_IS_LOCALE_JS : ERROR_MESSAGE_IS_LOCALE;
    }

    public String shortDescription() {
        return "Returns true if the current user locale is equal to the given argument";
    }
}

