/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.util.Date;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.logging.entity.LogEvent;
import org.structr.schema.action.ActionContext;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.function.UiFunction;

public class LogEventFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_LOG_EVENT = "Usage: ${log_event(action, message)}. Example: ${log_event('read', 'Book has been read')}";
    public static final String ERROR_MESSAGE_LOG_EVENT_JS = "Usage: ${{Structr.logEvent(action, message)}}. Example: ${{Structr.logEvent('read', 'Book has been read')}}";

    public String getName() {
        return "log_event()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 4)) {
            String action = sources[0].toString();
            String message = sources[1].toString();
            LogEvent logEvent = (LogEvent)StructrApp.getInstance().create(LogEvent.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)LogEvent.actionProperty, (Object)action), new NodeAttribute((PropertyKey)LogEvent.messageProperty, (Object)message), new NodeAttribute((PropertyKey)LogEvent.timestampProperty, (Object)new Date())});
            switch (sources.length) {
                case 4: {
                    String object = sources[3].toString();
                    logEvent.setProperties(logEvent.getSecurityContext(), new PropertyMap((PropertyKey)LogEvent.objectProperty, (Object)object));
                }
                case 3: {
                    String subject = sources[2].toString();
                    logEvent.setProperties(logEvent.getSecurityContext(), new PropertyMap((PropertyKey)LogEvent.subjectProperty, (Object)subject));
                }
            }
            return logEvent;
        }
        if (sources.length == 1 && sources[0] instanceof Map) {
            Map map = (Map)sources[0];
            String action = DOMNode.objectToString(map.get("action"));
            String message = DOMNode.objectToString(map.get("message"));
            String subject = DOMNode.objectToString(map.get("subject"));
            String object = DOMNode.objectToString(map.get("object"));
            return StructrApp.getInstance().create(LogEvent.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)LogEvent.actionProperty, (Object)action), new NodeAttribute((PropertyKey)LogEvent.messageProperty, (Object)message), new NodeAttribute((PropertyKey)LogEvent.timestampProperty, (Object)new Date()), new NodeAttribute((PropertyKey)LogEvent.subjectProperty, (Object)subject), new NodeAttribute((PropertyKey)LogEvent.objectProperty, (Object)object)});
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return "";
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_LOG_EVENT_JS : ERROR_MESSAGE_LOG_EVENT;
    }

    public String shortDescription() {
        return "Logs an event to the Structr log";
    }
}

