/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import javax.servlet.http.HttpServletResponse;
import org.structr.common.SecurityContext;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class SetResponseHeaderFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_SET_RESPONSE_HEADER = "Usage: ${set_response_header(field, value)}. Example: ${set_response_header('X-User', 'johndoe')}";
    public static final String ERROR_MESSAGE_SET_RESPONSE_HEADER_JS = "Usage: ${{Structr.setResponseHeader(field, value)}}. Example: ${{Structr.setResponseHeader('X-User', 'johndoe')}}";

    public String getName() {
        return "set_response_header()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (sources != null && sources.length == 2) {
            HttpServletResponse response;
            String name = sources[0].toString();
            String value = sources[1].toString();
            SecurityContext securityContext = ctx.getSecurityContext();
            if (securityContext != null && (response = securityContext.getResponse()) != null) {
                response.addHeader(name, value);
            }
            return "";
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_SET_RESPONSE_HEADER_JS : ERROR_MESSAGE_SET_RESPONSE_HEADER;
    }

    public String shortDescription() {
        return "Adds the given header field and value to the response of the current rendering run";
    }
}

