/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.StaticValue;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class ToGraphObjectFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_TO_GRAPH_OBJECT = "Usage: ${to_graph_object(obj [, view[, depth = 3]])}. Example: ${to_graph_object(this, 'public', 4)}";
    public static final String ERROR_MESSAGE_TO_GRAPH_OBJECT_JS = "Usage: ${{Structr.to_graph_object(obj [, view[, depth = 3]])}}. Example: ${{Structr.to_graph_object(Structr.get('this'), 'public', 4)}}";

    public String getName() {
        return "to_graph_object()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (sources != null && sources.length >= 1 && sources.length <= 3) {
            try {
                SecurityContext securityContext = ctx.getSecurityContext();
                StaticValue view = new StaticValue((Object)"public");
                if (sources.length > 1) {
                    view.set(securityContext, (Object)sources[1].toString());
                }
                int outputDepth = 3;
                if (sources.length > 2 && sources[2] instanceof Number) {
                    outputDepth = ((Number)sources[2]).intValue();
                }
                if (sources[0] instanceof GraphObject) {
                    return sources[0];
                }
                if (sources[0] instanceof List) {
                    List list = (List)sources[0];
                    ArrayList<Object> res = new ArrayList<Object>();
                    for (Object o : list) {
                        if (o instanceof Map) {
                            GraphObjectMap newObj = new GraphObjectMap();
                            ToGraphObjectFunction.recursivelyConvertMapToGraphObjectMap((GraphObjectMap)newObj, (Map)((Map)o), (int)outputDepth);
                            res.add(newObj);
                            continue;
                        }
                        if (o instanceof GraphObject) {
                            res.add((GraphObject)o);
                            continue;
                        }
                        if (!(o instanceof String)) continue;
                        GraphObjectMap stringWrapperObject = new GraphObjectMap();
                        stringWrapperObject.put((PropertyKey)new StringProperty("value"), o);
                        res.add(stringWrapperObject);
                    }
                    return res;
                }
                if (sources[0] instanceof Map) {
                    GraphObjectMap map = new GraphObjectMap();
                    ToGraphObjectFunction.recursivelyConvertMapToGraphObjectMap((GraphObjectMap)map, (Map)((Map)sources[0]), (int)outputDepth);
                    return map;
                }
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
            }
            return "";
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_TO_GRAPH_OBJECT_JS : ERROR_MESSAGE_TO_GRAPH_OBJECT;
    }

    public String shortDescription() {
        return "Converts the given entity to GraphObjectMap";
    }
}

