/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.resource.MaintenanceParameterResource;
import org.structr.web.entity.FileBase;

public class BulkMoveUnusedFilesCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkMoveUnusedFilesCommand.class.getName());

    public void execute(Map<String, Object> properties) throws FrameworkException {
        String mode = (String)properties.get("mode");
        String targetDir = (String)properties.get("target");
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "log";
        }
        if (StringUtils.isBlank((CharSequence)targetDir)) {
            targetDir = "unused";
        }
        logger.info("Starting moving of unused files...");
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        App app = StructrApp.getInstance();
        String filesLocation = (String)Settings.FilesPath.getValue();
        TreeSet<String> filePaths = new TreeSet<String>();
        if (graphDb != null) {
            List fileNodes = null;
            try (Tx tx = StructrApp.getInstance().tx();){
                fileNodes = app.nodeQuery(FileBase.class).getAsList();
                for (FileBase fileNode : fileNodes) {
                    String relativeFilePath = (String)fileNode.getProperty((PropertyKey)FileBase.relativeFilePath);
                    if (relativeFilePath == null) continue;
                    filePaths.add(relativeFilePath);
                }
                tx.success();
            }
            LinkedList files = new LinkedList();
            try {
                Files.walk(Paths.get(filesLocation, new String[0]), FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> files.add(file));
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
            }
            Path targetDirPath = null;
            targetDirPath = targetDir.startsWith("/") ? Paths.get(targetDir, new String[0]) : Paths.get(filesLocation, targetDir);
            if (mode.equals("move") && !Files.exists(targetDirPath, new LinkOption[0])) {
                try {
                    targetDirPath = Files.createDirectory(targetDirPath, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    logger.info("Could not create target directory {}: {}", new Object[]{targetDir, ex});
                    return;
                }
            }
            for (Path file2 : files) {
                String filePath = file2.toString();
                String relPath = StringUtils.stripStart((String)filePath.substring(filesLocation.length()), (String)"/");
                if (filePaths.contains(relPath)) continue;
                if (mode.equals("log")) {
                    System.out.println("File " + file2 + " doesn't exist in database (rel path: " + relPath + ")");
                    continue;
                }
                if (!mode.equals("move")) continue;
                try {
                    Path targetPath = Paths.get(targetDirPath.toString(), file2.getFileName().toString());
                    Files.move(file2, targetPath, new CopyOption[0]);
                    System.out.println("File " + file2.getFileName() + " moved to " + targetPath);
                }
                catch (IOException ex) {
                    logger.info("Could not move file {} to target directory {}: {}", new Object[]{file2, targetDir, ex});
                }
            }
        }
        logger.info("Done");
    }

    public boolean requiresEnclosingTransaction() {
        return false;
    }

    public boolean requiresFlushingOfCaches() {
        return false;
    }

    static {
        MaintenanceParameterResource.registerMaintenanceCommand((String)"moveUnusedFiles", BulkMoveUnusedFilesCommand.class);
    }
}

