/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.property;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SourceSearchAttribute;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.PropertyKey;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;

public class PathProperty
extends AbstractReadOnlyProperty<String> {
    private static final Logger logger = LoggerFactory.getLogger((String)PathProperty.class.getName());

    public PathProperty(String name) {
        super(name);
    }

    public Class relatedType() {
        return null;
    }

    public Class valueType() {
        return String.class;
    }

    public String typeName() {
        return "String";
    }

    public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        return FileHelper.getFolderPath((AbstractFile)obj);
    }

    public boolean isCollection() {
        return false;
    }

    public SortType getSortType() {
        return SortType.Default;
    }

    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, String searchValue, boolean exactMatch, Query query) {
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        SourceSearchAttribute attr = new SourceSearchAttribute(occur);
        Query q = app.nodeQuery(AbstractFile.class).and((PropertyKey)AbstractFile.name, (Object)PathHelper.getName((String)searchValue));
        try {
            for (AbstractFile fileOrFolder : q.getAsList()) {
                if (fileOrFolder == null || !((String)fileOrFolder.getProperty((PropertyKey)AbstractFile.path)).equals(searchValue)) continue;
                attr.addToResult((GraphObject)fileOrFolder);
            }
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
        }
        return attr;
    }
}

