/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.resource;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.resource.Resource;
import org.structr.web.entity.User;

public class LoginResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger((String)LoginResource.class.getName());

    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        return this.getUriPart().equals(part);
    }

    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        Principal user;
        String emailOrUsername;
        PropertyMap properties = PropertyMap.inputTypeToJavaType((SecurityContext)this.securityContext, User.class, propertySet);
        String name = (String)properties.get((PropertyKey)User.name);
        String email = (String)properties.get((PropertyKey)User.eMail);
        String password = (String)properties.get((PropertyKey)User.password);
        String string = emailOrUsername = StringUtils.isNotEmpty((CharSequence)email) ? email : name;
        if (StringUtils.isNotEmpty((CharSequence)emailOrUsername) && StringUtils.isNotEmpty((CharSequence)password) && (user = this.securityContext.getAuthenticator().doLogin(this.securityContext.getRequest(), emailOrUsername, password)) != null) {
            logger.info("Login successful: {}", new Object[]{user});
            this.securityContext.setCachedUser(user);
            RestMethodResult methodResult = new RestMethodResult(200);
            methodResult.addContent((GraphObject)user);
            return methodResult;
        }
        logger.info("Invalid credentials (name, email, password): {}, {}, {}", new Object[]{name, email, password});
        return new RestMethodResult(401);
    }

    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        throw new NotAllowedException("GET not allowed on " + this.getResourceSignature());
    }

    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new NotAllowedException("PUT not allowed on " + this.getResourceSignature());
    }

    public RestMethodResult doDelete() throws FrameworkException {
        throw new NotAllowedException("DELETE not allowed on " + this.getResourceSignature());
    }

    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return null;
    }

    public Class getEntityClass() {
        return null;
    }

    public String getUriPart() {
        return "login";
    }

    public String getResourceSignature() {
        return "_login";
    }

    public boolean isCollectionResource() {
        return false;
    }
}

