/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.MailHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.MailTemplate;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.resource.Resource;
import org.structr.web.entity.User;

public class ResetPasswordResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger((String)ResetPasswordResource.class.getName());

    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        return this.getUriPart().equals(part);
    }

    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        throw new NotAllowedException("GET not allowed on " + this.getResourceSignature());
    }

    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new NotAllowedException("PUT not allowed on " + this.getResourceSignature());
    }

    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        if (propertySet.containsKey(User.eMail.jsonName())) {
            String emailString = (String)propertySet.get(User.eMail.jsonName());
            if (StringUtils.isEmpty((CharSequence)emailString)) {
                return new RestMethodResult(400);
            }
            String localeString = (String)propertySet.get(MailTemplate.locale.jsonName());
            String confKey = UUID.randomUUID().toString();
            Principal user = (Principal)StructrApp.getInstance().nodeQuery(User.class).and((PropertyKey)User.eMail, (Object)emailString).getFirst();
            if (user != null) {
                user.setProperties(SecurityContext.getSuperUserInstance(), new PropertyMap(User.confirmationKey, (Object)confKey));
                if (!this.sendResetPasswordLink(user, propertySet, localeString, confKey)) {
                    return new RestMethodResult(400);
                }
                return new RestMethodResult(200);
            }
            return new RestMethodResult(200);
        }
        return new RestMethodResult(400);
    }

    public RestMethodResult doOptions() throws FrameworkException {
        throw new NotAllowedException("OPTIONS not allowed on " + this.getResourceSignature());
    }

    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return null;
    }

    private boolean sendResetPasswordLink(Principal user, Map<String, Object> propertySetFromUserPOST, String localeString, String confKey) {
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        ResetPasswordResource.populateReplacementMap(replacementMap, propertySetFromUserPOST);
        String userEmail = (String)user.getProperty((PropertyKey)User.eMail);
        String appHost = (String)Settings.ApplicationHost.getValue();
        Integer httpPort = (Integer)Settings.HttpPort.getValue();
        replacementMap.put(ResetPasswordResource.toPlaceholder(User.eMail.jsonName()), userEmail);
        replacementMap.put(ResetPasswordResource.toPlaceholder("link"), this.getTemplateText(TemplateKey.RESET_PASSWORD_BASE_URL, "http://" + appHost + ":" + httpPort, localeString, confKey) + this.getTemplateText(TemplateKey.RESET_PASSWORD_PAGE, "/reset-password", localeString, confKey) + "?" + this.getTemplateText(TemplateKey.RESET_PASSWORD_CONFIRM_KEY_KEY, "key", localeString, confKey) + "=" + confKey + "&" + this.getTemplateText(TemplateKey.RESET_PASSWORD_TARGET_PAGE_KEY, "target", localeString, confKey) + "=" + this.getTemplateText(TemplateKey.RESET_PASSWORD_TARGET_PAGE, "/reset-password", localeString, confKey));
        String textMailTemplate = this.getTemplateText(TemplateKey.RESET_PASSWORD_TEXT_BODY, "Go to ${link} to reset your password.", localeString, confKey);
        String htmlMailTemplate = this.getTemplateText(TemplateKey.RESET_PASSWORD_HTML_BODY, "<div>Click <a href='${link}'>here</a> to reset your password.</div>", localeString, confKey);
        String textMailContent = MailHelper.replacePlaceHoldersInTemplate((String)textMailTemplate, replacementMap);
        String htmlMailContent = MailHelper.replacePlaceHoldersInTemplate((String)htmlMailTemplate, replacementMap);
        try {
            MailHelper.sendHtmlMail((String)this.getTemplateText(TemplateKey.RESET_PASSWORD_SENDER_ADDRESS, "structr-mail-daemon@localhost", localeString, confKey), (String)this.getTemplateText(TemplateKey.RESET_PASSWORD_SENDER_NAME, "Structr Mail Daemon", localeString, confKey), (String)userEmail, (String)"", null, null, null, (String)this.getTemplateText(TemplateKey.RESET_PASSWORD_SUBJECT, "Request to reset your Structr password", localeString, confKey), (String)htmlMailContent, (String)textMailContent, (EmailAttachment[])new EmailAttachment[0]);
        }
        catch (Exception e) {
            logger.error("Unable to send reset password e-mail", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getTemplateText(TemplateKey key, String defaultValue, String localeString, String confKey) {
        try {
            MailTemplate template;
            Query query = StructrApp.getInstance().nodeQuery(MailTemplate.class).andName(key.name());
            if (localeString != null) {
                query.and((PropertyKey)MailTemplate.locale, (Object)localeString);
            }
            if ((template = (MailTemplate)query.getFirst()) != null) {
                String text = (String)template.getProperty((PropertyKey)MailTemplate.text);
                return text != null ? text : defaultValue;
            }
            return defaultValue;
        }
        catch (FrameworkException ex) {
            LoggerFactory.getLogger((String)ResetPasswordResource.class.getName()).warn("Could not get mail template for key " + (Object)((Object)key), (Throwable)ex);
            return null;
        }
    }

    private static void populateReplacementMap(Map<String, String> replacementMap, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            replacementMap.put(ResetPasswordResource.toPlaceholder(entry.getKey()), entry.getValue().toString());
        }
    }

    private static String toPlaceholder(String key) {
        return "${".concat(key).concat("}");
    }

    public Class getEntityClass() {
        return null;
    }

    public String getUriPart() {
        return "reset-password";
    }

    public String getResourceSignature() {
        return "_resetPassword";
    }

    public boolean isCollectionResource() {
        return false;
    }

    private static enum TemplateKey {
        RESET_PASSWORD_SENDER_NAME,
        RESET_PASSWORD_SENDER_ADDRESS,
        RESET_PASSWORD_SUBJECT,
        RESET_PASSWORD_TEXT_BODY,
        RESET_PASSWORD_HTML_BODY,
        RESET_PASSWORD_BASE_URL,
        RESET_PASSWORD_TARGET_PAGE,
        RESET_PASSWORD_ERROR_PAGE,
        RESET_PASSWORD_PAGE,
        RESET_PASSWORD_CONFIRM_KEY_KEY,
        RESET_PASSWORD_TARGET_PAGE_KEY,
        RESET_PASSWORD_ERROR_PAGE_KEY;

    }
}

