/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.AccessControllable;
import org.structr.common.AccessMode;
import org.structr.common.GraphObjectComparator;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.ThreadLocalMatcher;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.rest.auth.AuthHelper;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.schema.ConfigurationProvider;
import org.structr.util.Base64;
import org.structr.web.auth.UiAuthenticator;
import org.structr.web.common.FileHelper;
import org.structr.web.common.RenderContext;
import org.structr.web.common.StringRenderBuffer;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Linkable;
import org.structr.web.entity.Site;
import org.structr.web.entity.User;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;

public class HtmlServlet
extends HttpServlet
implements HttpServiceServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)HtmlServlet.class.getName());
    public static final String CONFIRM_REGISTRATION_PAGE = "/confirm_registration";
    public static final String RESET_PASSWORD_PAGE = "/reset-password";
    public static final String POSSIBLE_ENTRY_POINTS_KEY = "possibleEntryPoints";
    public static final String DOWNLOAD_AS_FILENAME_KEY = "filename";
    public static final String RANGE_KEY = "range";
    public static final String DOWNLOAD_AS_DATA_URL_KEY = "as-data-url";
    public static final String CONFIRM_KEY_KEY = "key";
    public static final String TARGET_PAGE_KEY = "target";
    public static final String ERROR_PAGE_KEY = "onerror";
    public static final String CUSTOM_RESPONSE_HEADERS = "HtmlServlet.customResponseHeaders";
    public static final String OBJECT_RESOLUTION_PROPERTIES = "HtmlServlet.resolveProperties";
    private static final List<String> customResponseHeaders = new LinkedList<String>();
    private static final ThreadLocalMatcher threadLocalUUIDMatcher = new ThreadLocalMatcher("[a-fA-F0-9]{32}");
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private final Pattern FilenameCleanerPattern = Pattern.compile("[\n\r]", 42);
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();
    private final Set<String> possiblePropertyNamesForEntityResolving = new LinkedHashSet<String>();
    private boolean isAsync = false;

    public HtmlServlet() {
        String customResponseHeadersString = (String)Settings.HtmlCustomResponseHeaders.getValue();
        if (StringUtils.isNotBlank((CharSequence)customResponseHeadersString)) {
            customResponseHeaders.addAll(Arrays.asList(customResponseHeadersString.split("[ ,]+")));
        }
        String resolvePropertiesSource = (String)Settings.HtmlResolveProperties.getValue();
        for (String src : resolvePropertiesSource.split("[, ]+")) {
            String name = src.trim();
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            this.possiblePropertyNamesForEntityResolving.add(name);
        }
        this.isAsync = (Boolean)Settings.Async.getValue();
    }

    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public String getModuleName() {
        return "ui";
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, final HttpServletResponse response) {
        Authenticator auth = this.getConfig().getAuthenticator();
        List<Page> pages = null;
        boolean requestUriContainsUuids = false;
        try {
            SecurityContext securityContext;
            this.assertInitialized();
            String path = request.getPathInfo();
            if (this.checkRegistration(auth, request, response, path)) {
                return;
            }
            if (this.checkResetPassword(auth, request, response, path)) {
                return;
            }
            try (Tx tx = StructrApp.getInstance().tx();){
                securityContext = auth.initializeAndExamineRequest(request, response);
                tx.success();
            }
            final App app = StructrApp.getInstance((SecurityContext)securityContext);
            try {
                tx = app.tx();
                var10_10 = null;
                try {
                    securityContext.setAccessMode(AccessMode.Frontend);
                    request.setCharacterEncoding("UTF-8");
                    response.setCharacterEncoding("UTF-8");
                    boolean dontCache = false;
                    logger.debug("Path info {}", (Object)path);
                    if (response.getStatus() == 302) {
                        tx.success();
                        return;
                    }
                    Principal user = securityContext.getUser(false);
                    if (user != null) {
                        dontCache = true;
                    }
                    final RenderContext renderContext = RenderContext.getInstance(securityContext, request, response);
                    renderContext.setResourceProvider(this.config.getResourceProvider());
                    RenderContext.EditMode edit = renderContext.getEditMode(user);
                    DOMNode rootElement = null;
                    AbstractNode dataNode = null;
                    String[] uriParts = PathHelper.getParts((String)path);
                    if (uriParts == null || uriParts.length == 0) {
                        rootElement = this.findIndexPage(securityContext, pages, edit);
                        logger.debug("No path supplied, trying to find index page");
                    } else if (rootElement == null) {
                        rootElement = this.findPage(securityContext, pages, path, edit);
                    } else {
                        dontCache = true;
                    }
                    if (rootElement == null) {
                        String queryString = request.getQueryString();
                        FileBase file = this.findFile(securityContext, request, path + (queryString != null ? "?" + queryString : ""));
                        if (file == null) {
                            file = this.findFile(securityContext, request, path);
                        }
                        if (file != null) {
                            this.streamFile(securityContext, file, request, response, edit);
                            tx.success();
                            return;
                        }
                        if (uriParts != null) {
                            Matcher matcher = (Matcher)threadLocalUUIDMatcher.get();
                            for (int i = 0; i < uriParts.length; ++i) {
                                request.setAttribute(uriParts[i], (Object)i);
                                matcher.reset(uriParts[i]);
                                requestUriContainsUuids |= matcher.matches();
                            }
                        }
                        if ((dataNode = !requestUriContainsUuids ? this.findFirstNodeByName(securityContext, request, path) : this.findNodeByUuid(securityContext, PathHelper.getName((String)path))) != null) {
                            request.removeAttribute(POSSIBLE_ENTRY_POINTS_KEY);
                            rootElement = this.findPage(securityContext, pages, StringUtils.substringBeforeLast((String)path, (String)"/"), edit);
                            renderContext.setDetailsDataObject((GraphObject)dataNode);
                            if (rootElement == null && dataNode instanceof DOMNode && (!(dataNode instanceof Page) || this.isVisibleForSite(request, (Page)dataNode))) {
                                rootElement = (DOMNode)dataNode;
                            }
                        }
                    }
                    if (rootElement == null) {
                        HttpBasicAuthResult authResult = this.checkHttpBasicAuth(request, response, path);
                        switch (authResult.authState()) {
                            case Authenticated: {
                                Linkable result = authResult.getRootElement();
                                if (result instanceof Page) {
                                    rootElement = (DOMNode)((Object)result);
                                    securityContext = authResult.getSecurityContext();
                                    renderContext.pushSecurityContext(securityContext);
                                    break;
                                }
                                if (!(result instanceof FileBase)) break;
                                this.streamFile(authResult.getSecurityContext(), (FileBase)result, request, response, RenderContext.EditMode.NONE);
                                tx.success();
                                return;
                            }
                            case MustAuthenticate: {
                                Page errorPage = (Page)StructrApp.getInstance().nodeQuery(Page.class).and(Page.showOnErrorCodes, (Object)"401", false).getFirst();
                                if (errorPage != null && this.isVisibleForSite(request, errorPage)) {
                                    rootElement = errorPage;
                                    dontCache = true;
                                    break;
                                }
                                response.sendError(401);
                                tx.success();
                                return;
                            }
                        }
                    }
                    if (rootElement == null) {
                        rootElement = this.notFound(response, securityContext);
                    }
                    if (rootElement == null) {
                        tx.success();
                        return;
                    }
                    if (RenderContext.EditMode.WIDGET.equals((Object)edit) || (dontCache |= ((Boolean)rootElement.getProperty((PropertyKey)Page.dontCache)).booleanValue())) {
                        HtmlServlet.setNoCacheHeaders(response);
                    }
                    if (!securityContext.isVisible((AccessControllable)rootElement)) {
                        rootElement = this.notFound(response, securityContext);
                        if (rootElement == null) {
                            tx.success();
                            return;
                        }
                    } else if (!RenderContext.EditMode.WIDGET.equals((Object)edit) && !dontCache && HtmlServlet.notModifiedSince(request, response, (AbstractNode)rootElement, dontCache)) {
                        ServletOutputStream out = response.getOutputStream();
                        out.flush();
                        out.close();
                    } else {
                        response.setCharacterEncoding("UTF-8");
                        String contentType = (String)rootElement.getProperty((PropertyKey)Page.contentType);
                        if (contentType == null) {
                            contentType = "text/html;charset=UTF-8";
                        }
                        if (contentType.equals("text/html")) {
                            contentType = contentType.concat(";charset=UTF-8");
                        }
                        response.setContentType(contentType);
                        HtmlServlet.setCustomResponseHeaders(response);
                        boolean createsRawData = (Boolean)rootElement.getProperty((PropertyKey)Page.pageCreatesRawData);
                        if (this.isAsync && !createsRawData) {
                            final AsyncContext async = request.startAsync();
                            final ServletOutputStream out = async.getResponse().getOutputStream();
                            final AtomicBoolean finished = new AtomicBoolean(false);
                            final DOMNode rootNode = rootElement;
                            threadPool.submit(new Runnable(){

                                @Override
                                public void run() {
                                    try (Tx tx = app.tx();){
                                        rootNode.render(renderContext, 0);
                                        finished.set(true);
                                        tx.success();
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                        logger.warn("Error while rendering page {}: {}", (Object)rootNode.getName(), (Object)t.getMessage());
                                        try {
                                            response.sendError(500);
                                            finished.set(true);
                                        }
                                        catch (IOException ex) {
                                            logger.warn("", (Throwable)ex);
                                        }
                                    }
                                }
                            });
                            out.setWriteListener(new WriteListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void onWritePossible() throws IOException {
                                    try {
                                        Queue<String> queue = renderContext.getBuffer().getQueue();
                                        while (out.isReady()) {
                                            String buffer = null;
                                            Queue<String> queue2 = queue;
                                            synchronized (queue2) {
                                                buffer = queue.poll();
                                            }
                                            if (buffer != null) {
                                                out.print(buffer);
                                                continue;
                                            }
                                            if (finished.get()) {
                                                async.complete();
                                                break;
                                            }
                                            Thread.sleep(1L);
                                        }
                                    }
                                    catch (Throwable t) {
                                        logger.warn("", t);
                                    }
                                }

                                public void onError(Throwable t) {
                                    logger.warn("", t);
                                }
                            });
                        } else {
                            StringRenderBuffer buffer = new StringRenderBuffer();
                            renderContext.setBuffer(buffer);
                            rootElement.render(renderContext, 0);
                            try {
                                response.getOutputStream().write(buffer.getBuffer().toString().getBytes("utf-8"));
                                response.getOutputStream().flush();
                                response.getOutputStream().close();
                            }
                            catch (IOException ioex) {
                                logger.warn("", (Throwable)ioex);
                            }
                        }
                    }
                    tx.success();
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (var10_10 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var10_10.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (FrameworkException fex) {
                logger.error("Exception while processing request", (Throwable)fex);
            }
        }
        catch (IOException | FrameworkException t) {
            logger.error("Exception while processing request", t);
            UiAuthenticator.writeInternalServerError(response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        Authenticator auth = this.getConfig().getAuthenticator();
        List<Page> pages = null;
        boolean requestUriContainsUuids = false;
        try {
            SecurityContext securityContext;
            this.assertInitialized();
            String path = request.getPathInfo();
            try (Tx tx = StructrApp.getInstance().tx();){
                securityContext = auth.initializeAndExamineRequest(request, response);
                tx.success();
            }
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            try {
                tx = app.tx();
                var10_10 = null;
                try {
                    securityContext.setAccessMode(AccessMode.Frontend);
                    request.setCharacterEncoding("UTF-8");
                    response.setCharacterEncoding("UTF-8");
                    response.setContentLength(0);
                    boolean dontCache = false;
                    logger.debug("Path info {}", (Object)path);
                    if (response.getStatus() == 302) {
                        tx.success();
                        return;
                    }
                    Principal user = securityContext.getUser(false);
                    if (user != null) {
                        dontCache = true;
                    }
                    RenderContext renderContext = RenderContext.getInstance(securityContext, request, response);
                    renderContext.setResourceProvider(this.config.getResourceProvider());
                    RenderContext.EditMode edit = renderContext.getEditMode(user);
                    DOMNode rootElement = null;
                    AbstractNode dataNode = null;
                    String[] uriParts = PathHelper.getParts((String)path);
                    if (uriParts == null || uriParts.length == 0) {
                        rootElement = this.findIndexPage(securityContext, pages, edit);
                        logger.debug("No path supplied, trying to find index page");
                    } else if (rootElement == null) {
                        rootElement = this.findPage(securityContext, pages, path, edit);
                    } else {
                        dontCache = true;
                    }
                    if (rootElement == null) {
                        FileBase file = this.findFile(securityContext, request, path);
                        if (file != null) {
                            tx.success();
                            return;
                        }
                        if (uriParts != null) {
                            Matcher matcher = (Matcher)threadLocalUUIDMatcher.get();
                            for (int i = 0; i < uriParts.length; ++i) {
                                request.setAttribute(uriParts[i], (Object)i);
                                matcher.reset(uriParts[i]);
                                requestUriContainsUuids |= matcher.matches();
                            }
                        }
                        if ((dataNode = !requestUriContainsUuids ? this.findFirstNodeByName(securityContext, request, path) : this.findNodeByUuid(securityContext, PathHelper.getName((String)path))) != null && !(dataNode instanceof Linkable)) {
                            request.removeAttribute(POSSIBLE_ENTRY_POINTS_KEY);
                            rootElement = this.findPage(securityContext, pages, StringUtils.substringBeforeLast((String)path, (String)"/"), edit);
                            renderContext.setDetailsDataObject((GraphObject)dataNode);
                            if (rootElement == null && dataNode instanceof DOMNode) {
                                rootElement = (DOMNode)dataNode;
                            }
                        }
                    }
                    if (rootElement == null) {
                        HttpBasicAuthResult authResult = this.checkHttpBasicAuth(request, response, path);
                        switch (authResult.authState()) {
                            case Authenticated: {
                                Linkable result = authResult.getRootElement();
                                if (result instanceof Page) {
                                    rootElement = (DOMNode)((Object)result);
                                    renderContext.pushSecurityContext(authResult.getSecurityContext());
                                    break;
                                }
                                if (!(result instanceof FileBase)) break;
                                tx.success();
                                return;
                            }
                            case MustAuthenticate: {
                                tx.success();
                                return;
                            }
                        }
                    }
                    if (rootElement == null) {
                        if (response.getStatus() == 401) {
                            try {
                                UiAuthenticator.writeUnauthorized(response);
                            }
                            catch (IllegalStateException authResult) {}
                        } else {
                            rootElement = this.notFound(response, securityContext);
                        }
                    }
                    if (rootElement == null) {
                        response.setContentLength(0);
                        response.getOutputStream().close();
                        tx.success();
                        return;
                    }
                    if (RenderContext.EditMode.WIDGET.equals((Object)edit) || (dontCache |= ((Boolean)rootElement.getProperty((PropertyKey)Page.dontCache)).booleanValue())) {
                        HtmlServlet.setNoCacheHeaders(response);
                    }
                    if (!securityContext.isVisible((AccessControllable)rootElement) && (rootElement = this.notFound(response, securityContext)) == null) {
                        tx.success();
                        return;
                    }
                    if (securityContext.isVisible((AccessControllable)rootElement)) {
                        if (!RenderContext.EditMode.WIDGET.equals((Object)edit) && !dontCache && HtmlServlet.notModifiedSince(request, response, (AbstractNode)rootElement, dontCache)) {
                            response.getOutputStream().close();
                        } else {
                            response.setCharacterEncoding("UTF-8");
                            String contentType = (String)rootElement.getProperty((PropertyKey)Page.contentType);
                            if (contentType == null) {
                                contentType = "text/html;charset=UTF-8";
                            }
                            if (contentType.equals("text/html")) {
                                contentType = contentType.concat(";charset=UTF-8");
                            }
                            response.setContentType(contentType);
                            HtmlServlet.setCustomResponseHeaders(response);
                            response.getOutputStream().close();
                        }
                    } else {
                        this.notFound(response, securityContext);
                        response.getOutputStream().close();
                    }
                    tx.success();
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (var10_10 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var10_10.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (Throwable fex) {
                logger.error("Exception while processing request", fex);
            }
        }
        catch (FrameworkException t) {
            logger.error("Exception while processing request", (Throwable)t);
            UiAuthenticator.writeInternalServerError(response);
        }
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        Authenticator auth = this.config.getAuthenticator();
        try {
            this.assertInitialized();
            try (Tx tx = StructrApp.getInstance().tx();){
                auth.initializeAndExamineRequest(request, response);
                tx.success();
            }
            response.setContentLength(0);
            response.setHeader("Allow", "GET,HEAD,OPTIONS");
        }
        catch (FrameworkException t) {
            logger.error("Exception while processing request", (Throwable)t);
            UiAuthenticator.writeInternalServerError(response);
        }
    }

    private Page notFound(HttpServletResponse response, SecurityContext securityContext) throws IOException, FrameworkException {
        List errorPages = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(Page.class).and(Page.showOnErrorCodes, (Object)"404", false).getAsList();
        for (Page errorPage : errorPages) {
            if (!this.isVisibleForSite(securityContext.getRequest(), errorPage)) continue;
            response.setStatus(404);
            return errorPage;
        }
        response.sendError(404);
        return null;
    }

    private AbstractNode findFirstNodeByName(SecurityContext securityContext, HttpServletRequest request, String path) throws FrameworkException {
        String name = PathHelper.getName((String)path);
        if (!name.isEmpty()) {
            logger.debug("Requested name: {}", (Object)name);
            Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery();
            ConfigurationProvider config = StructrApp.getConfiguration();
            if (!this.possiblePropertyNamesForEntityResolving.isEmpty()) {
                query.and();
                this.resolvePossiblePropertyNamesForObjectResolution(config, query, name);
                query.parent();
            }
            Result results = query.getResult();
            logger.debug("{} results", (Object)results.size());
            request.setAttribute(POSSIBLE_ENTRY_POINTS_KEY, (Object)results.getResults());
            return results.size() > 0 ? (AbstractNode)results.get(0) : null;
        }
        return null;
    }

    private AbstractNode findNodeByUuid(SecurityContext securityContext, String uuid) throws FrameworkException {
        if (!uuid.isEmpty()) {
            logger.debug("Requested id: {}", (Object)uuid);
            return (AbstractNode)StructrApp.getInstance((SecurityContext)securityContext).getNodeById(uuid);
        }
        return null;
    }

    private FileBase findFile(SecurityContext securityContext, HttpServletRequest request, String path) throws FrameworkException {
        List<Linkable> entryPoints = this.findPossibleEntryPoints(securityContext, request, path);
        if (entryPoints.isEmpty()) {
            entryPoints = this.findPossibleEntryPoints(securityContext, request, PathHelper.replaceWhitespaceByPlus((String)path));
        }
        if (entryPoints.isEmpty()) {
            entryPoints = this.findPossibleEntryPoints(securityContext, request, PathHelper.replaceWhitespaceByPercentTwenty((String)path));
        }
        for (Linkable node : entryPoints) {
            if (!(node instanceof FileBase) || !path.equals(node.getPath()) && !node.getUuid().equals(PathHelper.getName((String)path))) continue;
            return (FileBase)node;
        }
        return null;
    }

    private Page findPage(SecurityContext securityContext, List<Page> pages, String path, RenderContext.EditMode edit) throws FrameworkException {
        if (pages == null) {
            pages = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(Page.class).getAsList();
            Collections.sort(pages, new GraphObjectComparator(Page.position, "asc"));
        }
        for (Page page : pages) {
            String pagePath = page.getPath();
            if (pagePath == null || !pagePath.equals(path) || !RenderContext.EditMode.CONTENT.equals((Object)edit) && !this.isVisibleForSite(securityContext.getRequest(), page)) continue;
            return page;
        }
        String name = PathHelper.getName((String)path);
        for (Page page : pages) {
            String pageName = page.getName();
            if (pageName == null || !pageName.equals(name) || !RenderContext.EditMode.CONTENT.equals((Object)edit) && !this.isVisibleForSite(securityContext.getRequest(), page)) continue;
            return page;
        }
        for (Page page : pages) {
            String pageUuid = page.getUuid();
            if (pageUuid == null || !pageUuid.equals(name) || !RenderContext.EditMode.CONTENT.equals((Object)edit) && !this.isVisibleForSite(securityContext.getRequest(), page)) continue;
            return page;
        }
        return null;
    }

    private Page findIndexPage(SecurityContext securityContext, List<Page> pages, RenderContext.EditMode edit) throws FrameworkException {
        if (pages == null) {
            pages = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(Page.class).getAsList();
            Collections.sort(pages, new GraphObjectComparator(Page.position, "asc"));
        }
        for (Page page : pages) {
            if (!securityContext.isVisible((AccessControllable)page) || page.getProperty((PropertyKey)Page.position) == null || !RenderContext.EditMode.CONTENT.equals((Object)edit) && !this.isVisibleForSite(securityContext.getRequest(), page) && (!((Boolean)page.getProperty((PropertyKey)Page.enableBasicAuth)).booleanValue() || !((Boolean)page.getProperty((PropertyKey)Page.visibleToAuthenticatedUsers)).booleanValue())) continue;
            return page;
        }
        return null;
    }

    private boolean checkRegistration(Authenticator auth, HttpServletRequest request, HttpServletResponse response, String path) throws FrameworkException, IOException {
        logger.debug("Checking registration ...");
        String key = request.getParameter(CONFIRM_KEY_KEY);
        if (StringUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        String targetPage = this.filterMaliciousRedirects(request.getParameter(TARGET_PAGE_KEY));
        String errorPage = this.filterMaliciousRedirects(request.getParameter(ERROR_PAGE_KEY));
        if (CONFIRM_REGISTRATION_PAGE.equals(path)) {
            Result results;
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                results = app.nodeQuery(Principal.class).and(User.confirmationKey, (Object)key).getResult();
                tx.success();
            }
            if (!results.isEmpty()) {
                Principal user = (Principal)results.get(0);
                try (Tx tx = app.tx();){
                    user.setProperties(user.getSecurityContext(), new PropertyMap(User.confirmationKey, null));
                    if (((Boolean)Settings.RestUserAutologin.getValue()).booleanValue()) {
                        AuthHelper.doLogin((HttpServletRequest)request, (Principal)user);
                    }
                    tx.success();
                }
                if (StringUtils.isNotBlank((CharSequence)targetPage)) {
                    response.sendRedirect("/" + targetPage);
                }
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)errorPage)) {
                response.sendRedirect("/" + errorPage);
            }
            return true;
        }
        return false;
    }

    private boolean checkResetPassword(Authenticator auth, HttpServletRequest request, HttpServletResponse response, String path) throws FrameworkException, IOException {
        logger.debug("Checking registration ...");
        String key = request.getParameter(CONFIRM_KEY_KEY);
        if (StringUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        String targetPage = this.filterMaliciousRedirects(request.getParameter(TARGET_PAGE_KEY));
        if (RESET_PASSWORD_PAGE.equals(path)) {
            Result results;
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                results = app.nodeQuery(Principal.class).and(User.confirmationKey, (Object)key).getResult();
                tx.success();
            }
            if (!results.isEmpty()) {
                Principal user = (Principal)results.get(0);
                try (Tx tx = app.tx();){
                    user.setProperties(user.getSecurityContext(), new PropertyMap(User.confirmationKey, null));
                    if (((Boolean)Settings.RestUserAutologin.getValue()).booleanValue()) {
                        AuthHelper.doLogin((HttpServletRequest)request, (Principal)user);
                    }
                    tx.success();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)targetPage)) {
                response.sendRedirect(targetPage);
            }
            return true;
        }
        return false;
    }

    private List<Linkable> findPossibleEntryPointsByUuid(SecurityContext securityContext, HttpServletRequest request, String uuid) throws FrameworkException {
        List possibleEntryPoints = (List)request.getAttribute(POSSIBLE_ENTRY_POINTS_KEY);
        if (CollectionUtils.isNotEmpty((Collection)possibleEntryPoints)) {
            return possibleEntryPoints;
        }
        if (uuid.length() > 0) {
            logger.debug("Requested id: {}", (Object)uuid);
            Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery();
            query.and((PropertyKey)GraphObject.id, (Object)uuid);
            query.and().orType(Page.class).orTypes(File.class);
            Result results = query.getResult();
            logger.debug("{} results", (Object)results.size());
            request.setAttribute(POSSIBLE_ENTRY_POINTS_KEY, (Object)results.getResults());
            return results.getResults();
        }
        return Collections.EMPTY_LIST;
    }

    private List<Linkable> findPossibleEntryPointsByPath(SecurityContext securityContext, HttpServletRequest request, String path) throws FrameworkException {
        List possibleEntryPoints = (List)request.getAttribute(POSSIBLE_ENTRY_POINTS_KEY);
        if (CollectionUtils.isNotEmpty((Collection)possibleEntryPoints)) {
            return possibleEntryPoints;
        }
        if (path.length() > 0) {
            logger.debug("Requested path: {}", (Object)path);
            Query pageQuery = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery();
            pageQuery.and(Page.path, (Object)path).andType(Page.class);
            Result pages = pageQuery.getResult();
            Query fileQuery = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery();
            fileQuery.and(AbstractFile.path, (Object)path).andTypes(File.class);
            Result files = fileQuery.getResult();
            logger.debug("Found {} pages and {} files/folders", new Object[]{pages.size(), files.size()});
            List linkables = pages.getResults();
            linkables.addAll(files.getResults());
            request.setAttribute(POSSIBLE_ENTRY_POINTS_KEY, (Object)linkables);
            return linkables;
        }
        return Collections.EMPTY_LIST;
    }

    private List<Linkable> findPossibleEntryPoints(SecurityContext securityContext, HttpServletRequest request, String path) throws FrameworkException {
        List<Linkable> possibleEntryPoints = (List<Linkable>)request.getAttribute(POSSIBLE_ENTRY_POINTS_KEY);
        if (CollectionUtils.isNotEmpty((Collection)possibleEntryPoints)) {
            return possibleEntryPoints;
        }
        int numberOfParts = PathHelper.getParts((String)path).length;
        if (numberOfParts > 0) {
            logger.debug("Requested name {}", (Object)path);
            possibleEntryPoints = this.findPossibleEntryPointsByPath(securityContext, request, path);
            if (possibleEntryPoints.isEmpty() && numberOfParts == 1) {
                possibleEntryPoints = this.findPossibleEntryPointsByUuid(securityContext, request, PathHelper.getName((String)path));
            }
            return possibleEntryPoints;
        }
        return Collections.EMPTY_LIST;
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "private, max-age=0, s-maxage=0, no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache, no-store");
        response.setDateHeader("Expires", 0L);
    }

    private static void setCustomResponseHeaders(HttpServletResponse response) {
        for (String header : customResponseHeaders) {
            String[] keyValuePair = header.split("[ :]+");
            response.setHeader(keyValuePair[0], keyValuePair[1]);
            logger.debug("Set custom response header: {} {}", new Object[]{keyValuePair[0], keyValuePair[1]});
        }
    }

    private static boolean notModifiedSince(HttpServletRequest request, HttpServletResponse response, AbstractNode node, boolean dontCache) {
        boolean notModified = false;
        Date lastModified = node.getLastModifiedDate();
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        response.setHeader("Date", httpDateFormat.format(new Date()));
        GregorianCalendar cal = new GregorianCalendar();
        Integer seconds = (Integer)node.getProperty(Page.cacheForSeconds);
        if (!dontCache && seconds != null) {
            ((Calendar)cal).add(13, seconds);
            response.setHeader("Cache-Control", "max-age=" + seconds + ", s-maxage=" + seconds + "");
            response.setHeader("Expires", httpDateFormat.format(cal.getTime()));
        } else if (!dontCache) {
            response.setHeader("Cache-Control", "no-cache, must-revalidate, proxy-revalidate");
        } else {
            response.setHeader("Cache-Control", "private, no-cache, no-store, max-age=0, s-maxage=0, must-revalidate, proxy-revalidate");
        }
        if (lastModified != null) {
            Date roundedLastModified = DateUtils.round((Date)lastModified, (int)13);
            response.setHeader("Last-Modified", httpDateFormat.format(roundedLastModified));
            String ifModifiedSince = request.getHeader("If-Modified-Since");
            if (StringUtils.isNotBlank((CharSequence)ifModifiedSince)) {
                try {
                    Date ifModSince = httpDateFormat.parse(ifModifiedSince);
                    if (ifModSince != null && (roundedLastModified.equals(ifModSince) || roundedLastModified.before(ifModSince))) {
                        notModified = true;
                        response.setStatus(304);
                        response.setHeader("Vary", "Accept-Encoding");
                    }
                }
                catch (ParseException ex) {
                    logger.warn("Could not parse If-Modified-Since header", (Throwable)ex);
                }
            }
        }
        return notModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamFile(SecurityContext securityContext, FileBase file, HttpServletRequest request, HttpServletResponse response, RenderContext.EditMode edit) throws IOException {
        if (!securityContext.isVisible((AccessControllable)file)) {
            response.sendError(404);
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        String downloadAsFilename = request.getParameter(DOWNLOAD_AS_FILENAME_KEY);
        LinkedHashMap<String, Object> callbackMap = new LinkedHashMap<String, Object>();
        callbackMap.put("editMode", (Object)edit);
        if (downloadAsFilename != null) {
            String cleanedFilename = this.FilenameCleanerPattern.matcher(downloadAsFilename).replaceAll("");
            response.addHeader("Content-Disposition", "attachment; filename=\"" + cleanedFilename + "\"");
            callbackMap.put("requestedFileName", downloadAsFilename);
        }
        if (!RenderContext.EditMode.WIDGET.equals((Object)edit) && HtmlServlet.notModifiedSince(request, response, (AbstractNode)file, false)) {
            out.flush();
            out.close();
            callbackMap.put("statusCode", 304);
        } else {
            String downloadAsDataUrl = request.getParameter(DOWNLOAD_AS_DATA_URL_KEY);
            if (downloadAsDataUrl != null) {
                IOUtils.write((String)FileHelper.getBase64String(file), (OutputStream)out, (String)"utf-8");
                response.setContentType("text/plain");
                response.setStatus(200);
                out.flush();
                out.close();
                callbackMap.put("statusCode", 200);
            } else {
                InputStream in = file.getInputStream();
                String contentType = file.getContentType();
                if (contentType != null) {
                    response.setContentType(contentType);
                } else {
                    response.setContentType("application/octet-stream");
                }
                String range = request.getHeader("Range");
                try {
                    if (StringUtils.isNotEmpty((CharSequence)range)) {
                        long len = file.getSize();
                        long start = 0L;
                        long end = len - 1L;
                        Matcher matcher = Pattern.compile("bytes=(?<start>\\d*)-(?<end>\\d*)").matcher(range);
                        if (matcher.matches()) {
                            String startGroup = matcher.group("start");
                            start = startGroup.isEmpty() ? start : Long.valueOf(startGroup);
                            start = Math.max(0L, start);
                            String endGroup = matcher.group("end");
                            end = endGroup.isEmpty() ? end : Long.valueOf(endGroup);
                            end = end > len - 1L ? len - 1L : end;
                        }
                        long contentLength = end - start + 1L;
                        response.setHeader("Accept-Ranges", "bytes");
                        response.setHeader("Content-Range", String.format("bytes %s-%s/%s", start, end, len));
                        response.setHeader("Content-Length", String.format("%s", contentLength));
                        response.setStatus(206);
                        callbackMap.put("statusCode", 206);
                        IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)start, (long)contentLength);
                    } else {
                        response.setStatus(200);
                        callbackMap.put("statusCode", 200);
                        IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (in != null) {
                        in.close();
                    }
                    response.setStatus(200);
                }
            }
        }
        if (!RenderContext.EditMode.WIDGET.equals((Object)edit)) {
            try {
                file.invokeMethod("onDownload", callbackMap, false);
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
    }

    private boolean isVisibleForSite(HttpServletRequest request, Page page) {
        logger.debug("Page: {} [{}], server name: {}, server port: {}", new Object[]{page.getName(), page.getUuid(), request.getServerName(), request.getServerPort()});
        Site site = (Site)((Object)page.getProperty((PropertyKey)Page.site));
        if (site == null) {
            logger.debug("Page {} [{}] has no site assigned.", new Object[]{page.getName(), page.getUuid()});
            return true;
        }
        logger.debug("Checking site: {} [{}], hostname: {}, port: {}", new Object[]{site.getName(), site.getUuid(), site.getProperty((PropertyKey)Site.hostname), site.getProperty((PropertyKey)Site.port)});
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        if (StringUtils.isNotBlank((CharSequence)serverName) && !serverName.equals(site.getProperty((PropertyKey)Site.hostname))) {
            logger.debug("Server name {} does not fit site hostname {}", new Object[]{serverName, site.getProperty((PropertyKey)Site.hostname)});
            return false;
        }
        Integer sitePort = (Integer)site.getProperty((PropertyKey)Site.port);
        if (sitePort != null && serverPort != sitePort) {
            logger.debug("Server port {} does not match site port {}", new Object[]{serverPort, sitePort});
            return false;
        }
        logger.debug("Matching site: {} [{}], hostname: {}, port: {}", new Object[]{site.getName(), site.getUuid(), site.getProperty((PropertyKey)Site.hostname), site.getProperty((PropertyKey)Site.port)});
        return true;
    }

    private void resolvePossiblePropertyNamesForObjectResolution(ConfigurationProvider config, Query query, String name) {
        for (String possiblePropertyName : this.possiblePropertyNamesForEntityResolving) {
            String[] parts = possiblePropertyName.split("\\.");
            String className = AbstractNode.class.getSimpleName();
            String keyName = AbstractNode.name.jsonName();
            switch (parts.length) {
                case 2: {
                    className = parts[0];
                    keyName = parts[1];
                    break;
                }
                default: {
                    logger.warn("Unable to process key for object resolution {}.", (Object)possiblePropertyName);
                }
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{className, keyName})) continue;
            Class type = config.getNodeEntityClass(className);
            if (type != null) {
                PropertyKey key = config.getPropertyKeyForJSONName(type, keyName, false);
                if (key != null) {
                    try {
                        PropertyConverter converter = key.inputConverter(SecurityContext.getSuperUserInstance());
                        if (converter != null) {
                            query.or(key, converter.convert((Object)name));
                            continue;
                        }
                        query.or(key, (Object)name);
                    }
                    catch (FrameworkException frameworkException) {}
                    continue;
                }
                logger.warn("Unable to find property key {} of type {} defined in key {} used for object resolution.", new Object[]{keyName, className, possiblePropertyName});
                continue;
            }
            logger.warn("Unable to find type {} defined in key {} used for object resolution.", new Object[]{className, possiblePropertyName});
        }
    }

    private HttpBasicAuthResult checkHttpBasicAuth(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, FrameworkException {
        Linkable possiblePage = null;
        if (possiblePage == null) {
            possiblePage = (Linkable)StructrApp.getInstance().nodeQuery(Page.class).and(Page.path, (Object)path).and((PropertyKey)Page.enableBasicAuth, (Object)true).sort(Page.position).getFirst();
        }
        if (possiblePage == null) {
            possiblePage = (Linkable)StructrApp.getInstance().nodeQuery(Page.class).and((PropertyKey)Page.name, (Object)PathHelper.getName((String)path)).and((PropertyKey)Page.enableBasicAuth, (Object)true).sort(Page.position).getFirst();
        }
        if (possiblePage == null) {
            possiblePage = (Linkable)StructrApp.getInstance().nodeQuery(File.class).and((PropertyKey)File.path, (Object)path).and((PropertyKey)File.enableBasicAuth, (Object)true).getFirst();
        }
        if (possiblePage == null) {
            possiblePage = (Linkable)StructrApp.getInstance().nodeQuery(File.class).and((PropertyKey)File.name, (Object)PathHelper.getName((String)path)).and((PropertyKey)File.enableBasicAuth, (Object)true).getFirst();
        }
        if (possiblePage != null) {
            Linkable page;
            SecurityContext securityContext;
            Principal principal;
            String realm = (String)possiblePage.getProperty((PropertyKey)Page.basicAuthRealm);
            if (realm == null) {
                realm = possiblePage.getName();
            }
            if ((principal = this.getPrincipalForAuthorizationHeader(request.getHeader("Authorization"))) != null && (securityContext = SecurityContext.getInstance((Principal)principal, (AccessMode)AccessMode.Frontend)) != null && (page = (Linkable)StructrApp.getInstance((SecurityContext)securityContext).get(Linkable.class, possiblePage.getUuid())) != null) {
                securityContext.setRequest(request);
                securityContext.setResponse(response);
                return new HttpBasicAuthResult(AuthState.Authenticated, securityContext, page);
            }
            response.setHeader("WWW-Authenticate", "BASIC realm=\"" + realm + "\"");
            response.setStatus(401);
            return HttpBasicAuthResult.MUST_AUTHENTICATE;
        }
        return HttpBasicAuthResult.NO_BASIC_AUTH;
    }

    private Principal getPrincipalForAuthorizationHeader(String authHeader) {
        String[] authParts;
        if (authHeader != null && (authParts = authHeader.split(" ")).length == 2) {
            String value;
            String[] parts;
            String authType = authParts[0];
            String authValue = authParts[1];
            String username = null;
            String password = null;
            if ("Basic".equals(authType) && (parts = (value = new String(Base64.decode((String)authValue), Charset.forName("utf-8"))).split(":")).length == 2) {
                username = parts[0];
                password = parts[1];
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username, password})) {
                try {
                    return AuthHelper.getPrincipalForPassword((PropertyKey)Principal.name, username, password);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void assertInitialized() throws FrameworkException {
        if (!Services.getInstance().isInitialized()) {
            throw new FrameworkException(503, "System is not initialized yet.");
        }
    }

    private String filterMaliciousRedirects(String source) {
        if (source != null) {
            try {
                URI uri = URI.create(source).normalize();
                if (uri.isAbsolute()) {
                    URI rel = uri.relativize(uri);
                    return URI.create(uri.getPath() + rel.toString()).toString();
                }
                return uri.toString();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static class HttpBasicAuthResult {
        public static final HttpBasicAuthResult MUST_AUTHENTICATE = new HttpBasicAuthResult(AuthState.MustAuthenticate);
        public static final HttpBasicAuthResult NO_BASIC_AUTH = new HttpBasicAuthResult(AuthState.NoBasicAuth);
        private SecurityContext securityContext = null;
        private Linkable rootElement = null;
        private AuthState authState = null;

        public HttpBasicAuthResult(AuthState authState) {
            this(authState, null, null);
        }

        public HttpBasicAuthResult(AuthState authState, SecurityContext securityContext, Linkable rootElement) {
            this.securityContext = securityContext;
            this.rootElement = rootElement;
            this.authState = authState;
        }

        public SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        public AuthState authState() {
            return this.authState;
        }

        public Linkable getRootElement() {
            return this.rootElement;
        }
    }

    private static enum AuthState {
        NoBasicAuth,
        MustAuthenticate,
        Authenticated;

    }
}

