/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket;

import com.google.gson.Gson;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.structr.core.auth.Authenticator;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.WebsocketController;

public class StructrWebSocketCreator
implements WebSocketCreator {
    private static final String STRUCTR_PROTOCOL = "structr";
    private WebsocketController syncController = null;
    private Authenticator authenticator = null;
    private Gson gson = null;

    public StructrWebSocketCreator(WebsocketController syncController, Gson gson, Authenticator authenticator) {
        this.syncController = syncController;
        this.authenticator = authenticator;
        this.gson = gson;
    }

    public Object createWebSocket(ServletUpgradeRequest request, ServletUpgradeResponse response) {
        for (String subprotocol : request.getSubProtocols()) {
            if (!STRUCTR_PROTOCOL.equals(subprotocol)) continue;
            response.setAcceptedSubProtocol(subprotocol);
            StructrWebSocket webSocket = new StructrWebSocket(this.syncController, this.gson, this.authenticator);
            webSocket.setRequest(request.getHttpServletRequest());
            return webSocket;
        }
        return null;
    }
}

