/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.StaticValue;
import org.structr.core.Value;
import org.structr.core.property.PropertyKey;
import org.structr.core.rest.GraphObjectGSONAdapter;
import org.structr.core.rest.JsonInputGSONAdapter;
import org.structr.websocket.message.WebSocketMessage;

public class WebSocketDataGSONAdapter
implements JsonSerializer<WebSocketMessage>,
JsonDeserializer<WebSocketMessage> {
    private static final Logger logger = LoggerFactory.getLogger((String)WebSocketDataGSONAdapter.class.getName());
    private final Value<String> propertyView = new StaticValue((Object)"public");
    private GraphObjectGSONAdapter graphObjectSerializer = null;

    public WebSocketDataGSONAdapter(int outputNestingDepth) {
        this.graphObjectSerializer = new GraphObjectGSONAdapter(this.propertyView, outputNestingDepth);
    }

    public JsonElement serialize(WebSocketMessage src, Type typeOfSrc, JsonSerializationContext context) {
        String key;
        JsonObject root = new JsonObject();
        JsonObject jsonNodeData = new JsonObject();
        JsonObject jsonRelData = new JsonObject();
        JsonArray removedProperties = new JsonArray();
        JsonArray modifiedProperties = new JsonArray();
        if (src.getCommand() != null) {
            root.add("command", (JsonElement)new JsonPrimitive(src.getCommand()));
        }
        if (src.getId() != null) {
            root.add("id", (JsonElement)new JsonPrimitive(src.getId()));
        }
        if (src.getPageId() != null) {
            root.add("pageId", (JsonElement)new JsonPrimitive(src.getPageId()));
        }
        if (src.getMessage() != null) {
            root.add("message", (JsonElement)new JsonPrimitive(src.getMessage()));
        }
        if (src.getJsonErrorObject() != null) {
            root.add("error", src.getJsonErrorObject());
        }
        if (src.getCode() != 0) {
            root.add("code", (JsonElement)new JsonPrimitive((Number)src.getCode()));
        }
        if (src.getSessionId() != null) {
            root.add("sessionId", (JsonElement)new JsonPrimitive(src.getSessionId()));
        }
        if (src.getCallback() != null) {
            root.add("callback", (JsonElement)new JsonPrimitive(src.getCallback()));
        }
        if (src.getButton() != null) {
            root.add("button", (JsonElement)new JsonPrimitive(src.getButton()));
        }
        if (src.getParent() != null) {
            root.add("parent", (JsonElement)new JsonPrimitive(src.getParent()));
        }
        if (src.getView() != null) {
            root.add("view", (JsonElement)new JsonPrimitive(src.getView()));
        }
        if (src.getSortKey() != null) {
            root.add("sort", (JsonElement)new JsonPrimitive(src.getSortKey()));
        }
        if (src.getSortOrder() != null) {
            root.add("order", (JsonElement)new JsonPrimitive(src.getSortOrder()));
        }
        if (src.getPageSize() > 0) {
            root.add("pageSize", (JsonElement)new JsonPrimitive((Number)src.getPageSize()));
        }
        if (src.getPage() > 0) {
            root.add("page", (JsonElement)new JsonPrimitive((Number)src.getPage()));
        }
        JsonArray nodesWithChildren = new JsonArray();
        Set<String> nwc = src.getNodesWithChildren();
        if (nwc != null && !src.getNodesWithChildren().isEmpty()) {
            for (String string : nwc) {
                nodesWithChildren.add((JsonElement)new JsonPrimitive(string));
            }
            root.add("nodesWithChildren", (JsonElement)nodesWithChildren);
        }
        root.add("sessionValid", (JsonElement)new JsonPrimitive(Boolean.valueOf(src.isSessionValid())));
        if (src.getGraphObject() != null) {
            if (!src.getModifiedProperties().isEmpty()) {
                for (PropertyKey propertyKey : src.getModifiedProperties()) {
                    modifiedProperties.add((JsonElement)this.toJsonPrimitive(propertyKey));
                }
                root.add("modifiedProperties", (JsonElement)modifiedProperties);
            }
            if (!src.getRemovedProperties().isEmpty()) {
                for (PropertyKey propertyKey : src.getRemovedProperties()) {
                    removedProperties.add((JsonElement)this.toJsonPrimitive(propertyKey));
                }
                root.add("removedProperties", (JsonElement)removedProperties);
            }
        }
        if (src.getNodeData() != null) {
            for (Map.Entry entry : src.getNodeData().entrySet()) {
                Object v = entry.getValue();
                key = (String)entry.getKey();
                if (v == null) continue;
                jsonNodeData.add(key, (JsonElement)this.toJsonPrimitive(v));
            }
            root.add("data", (JsonElement)jsonNodeData);
        }
        if (src.getRelData() != null) {
            for (Map.Entry entry : src.getRelData().entrySet()) {
                Object v = entry.getValue();
                key = (String)entry.getKey();
                if (v == null) continue;
                jsonRelData.add(key, (JsonElement)this.toJsonPrimitive(v));
            }
            root.add("relData", (JsonElement)jsonRelData);
        }
        if (src.getResult() != null) {
            if (src.getView() != null) {
                try {
                    this.propertyView.set(null, (Object)src.getView());
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to set property view", (Throwable)fex);
                }
            } else {
                try {
                    this.propertyView.set(null, (Object)"ui");
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to set property view", (Throwable)fex);
                }
            }
            JsonArray result = new JsonArray();
            for (GraphObject graphObject : src.getResult()) {
                result.add(this.graphObjectSerializer.serialize(graphObject, System.currentTimeMillis()));
            }
            root.add("result", (JsonElement)result);
            root.add("rawResultCount", (JsonElement)this.toJsonPrimitive(src.getRawResultCount()));
        }
        return root;
    }

    private JsonPrimitive toJsonPrimitive(Object value) {
        JsonPrimitive jp = value instanceof PropertyKey ? new JsonPrimitive(((PropertyKey)value).jsonName()) : (value instanceof String ? new JsonPrimitive((String)value) : (value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : (value instanceof Character ? new JsonPrimitive((Character)value) : new JsonPrimitive(value.toString())))));
        return jp;
    }

    public WebSocketMessage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        WebSocketMessage webSocketData = new WebSocketMessage();
        if (json instanceof JsonObject) {
            JsonPrimitive sessionId;
            JsonObject root = json.getAsJsonObject();
            JsonObject nodeData = root.getAsJsonObject("data");
            JsonObject relData = root.getAsJsonObject("relData");
            if (root.has("command")) {
                webSocketData.setCommand(root.getAsJsonPrimitive("command").getAsString());
            }
            if (root.has("id")) {
                webSocketData.setId(root.getAsJsonPrimitive("id").getAsString());
            }
            if (root.has("pageId")) {
                webSocketData.setPageId(root.getAsJsonPrimitive("pageId").getAsString());
            }
            if (root.has("sessionId") && (sessionId = root.getAsJsonPrimitive("sessionId")) != null) {
                webSocketData.setSessionId(sessionId.getAsString());
            }
            if (root.has("callback")) {
                webSocketData.setCallback(root.getAsJsonPrimitive("callback").getAsString());
            }
            if (root.has("button")) {
                webSocketData.setButton(root.getAsJsonPrimitive("button").getAsString());
            }
            if (root.has("parent")) {
                webSocketData.setParent(root.getAsJsonPrimitive("parent").getAsString());
            }
            if (root.has("view")) {
                webSocketData.setView(root.getAsJsonPrimitive("view").getAsString());
            }
            if (root.has("sort")) {
                webSocketData.setSortKey(root.getAsJsonPrimitive("sort").getAsString());
            }
            if (root.has("order")) {
                webSocketData.setSortOrder(root.getAsJsonPrimitive("order").getAsString());
            }
            if (root.has("pageSize")) {
                webSocketData.setPageSize(root.getAsJsonPrimitive("pageSize").getAsInt());
            }
            if (root.has("page")) {
                webSocketData.setPage(root.getAsJsonPrimitive("page").getAsInt());
            }
            if (nodeData != null) {
                JsonInputGSONAdapter adapter = new JsonInputGSONAdapter();
                for (Map.Entry entry : nodeData.entrySet()) {
                    JsonElement obj = (JsonElement)entry.getValue();
                    LinkedList<Object> value = null;
                    if (obj instanceof JsonPrimitive) {
                        value = JsonInputGSONAdapter.fromPrimitive((JsonPrimitive)obj.getAsJsonPrimitive());
                    } else if (obj instanceof JsonObject) {
                        value = adapter.deserialize(obj, typeOfT, context);
                    } else if (obj instanceof JsonArray) {
                        JsonArray array = obj.getAsJsonArray();
                        LinkedList<Object> list = new LinkedList<Object>();
                        for (JsonElement element : array) {
                            if (element.isJsonPrimitive()) {
                                list.add(JsonInputGSONAdapter.fromPrimitive((JsonPrimitive)element.getAsJsonPrimitive()));
                                continue;
                            }
                            if (!element.isJsonObject()) continue;
                            list.add(JsonInputGSONAdapter.deserialize((JsonElement)element, (JsonDeserializationContext)context));
                        }
                        value = list;
                    } else if (obj instanceof JsonNull) {
                        value = null;
                    } else if (obj != null) {
                        value = obj.getAsString();
                    }
                    webSocketData.setNodeData((String)entry.getKey(), value);
                }
            }
            if (relData != null) {
                for (Map.Entry entry : relData.entrySet()) {
                    JsonElement obj = (JsonElement)entry.getValue();
                    if (obj instanceof JsonNull || obj.isJsonNull()) {
                        webSocketData.setRelData((String)entry.getKey(), null);
                        continue;
                    }
                    try {
                        webSocketData.setRelData((String)entry.getKey(), obj.getAsString());
                    }
                    catch (Throwable t) {
                        webSocketData.setRelData((String)entry.getKey(), null);
                    }
                }
            }
        }
        return webSocketData;
    }
}

