/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.RelationshipType;
import org.structr.common.AccessControllable;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.StructrTransactionListener;
import org.structr.core.TransactionSource;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.User;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.Node;

public class WebsocketController
implements StructrTransactionListener {
    private static final Logger logger = LoggerFactory.getLogger((String)WebsocketController.class.getName());
    private static final Set<String> BroadcastCommands = new HashSet<String>(Arrays.asList("UPDATE", "ADD", "CREATE"));
    private final Set<StructrWebSocket> clients = new ConcurrentHashSet();
    private Gson gson = null;

    public WebsocketController(Gson gson) {
        this.gson = gson;
    }

    public void registerClient(StructrWebSocket client) {
        this.clients.add(client);
    }

    public void unregisterClient(StructrWebSocket client) {
        this.clients.remove(client);
    }

    private void broadcast(WebSocketMessage webSocketData) {
        this.broadcast(webSocketData, null);
    }

    private void broadcast(WebSocketMessage webSocketData, String exemptedSessionId) {
        webSocketData.setSessionValid(true);
        String pagePath = (String)webSocketData.getNodeData().get("pagePath");
        String encodedPath = URIUtil.encodePath((String)pagePath);
        LinkedList<StructrWebSocket> clientsToRemove = new LinkedList<StructrWebSocket>();
        List<? extends GraphObject> result = webSocketData.getResult();
        String command = webSocketData.getCommand();
        GraphObject obj = webSocketData.getGraphObject();
        for (StructrWebSocket socket : this.clients) {
            String message;
            AbstractNode node;
            Session session;
            String clientPagePath = socket.getPagePath();
            if (clientPagePath != null && !clientPagePath.equals(encodedPath) || (session = socket.getSession()) == null || !socket.isAuthenticated()) continue;
            SecurityContext securityContext = socket.getSecurityContext();
            if (exemptedSessionId != null && exemptedSessionId.equals(securityContext.getSessionId()) || (!(obj instanceof AbstractNode) ? !socket.isPrivilegedUser(socket.getCurrentUser()) : (node = (AbstractNode)obj).isHidden() || !securityContext.isVisible((AccessControllable)node))) continue;
            if (result != null && !result.isEmpty() && BroadcastCommands.contains(command)) {
                WebSocketMessage clientData = webSocketData.copy();
                clientData.setResult(this.filter(securityContext, result));
                message = this.gson.toJson((Object)clientData, WebSocketMessage.class);
            } else {
                message = this.gson.toJson((Object)webSocketData, WebSocketMessage.class);
            }
            try {
                session.getRemote().sendString(message);
            }
            catch (Throwable t) {
                WebSocketException wse;
                if (t instanceof WebSocketException && "RemoteEndpoint unavailable, current state [CLOSED], expecting [OPEN or CONNECTED]".equals((wse = (WebSocketException)t).getMessage())) {
                    clientsToRemove.add(socket);
                }
                logger.debug("Error sending message to client.", t);
            }
        }
        for (StructrWebSocket s : clientsToRemove) {
            this.unregisterClient(s);
            logger.warn("Client removed from broadcast list: {}", (Object)s);
        }
    }

    private <T extends GraphObject> List<T> filter(SecurityContext securityContext, List<T> all) {
        LinkedList<GraphObject> filteredResult = new LinkedList<GraphObject>();
        for (GraphObject obj : all) {
            if (!securityContext.isVisible((AccessControllable)((AbstractNode)obj))) continue;
            filteredResult.add(obj);
        }
        return filteredResult;
    }

    public void beforeCommit(SecurityContext securityContext, Collection<ModificationEvent> modificationEvents, TransactionSource source) {
    }

    public void afterCommit(SecurityContext securityContext, Collection<ModificationEvent> modificationEvents, TransactionSource source) {
        for (ModificationEvent event : modificationEvents) {
            try {
                WebSocketMessage message = this.getMessageForEvent(securityContext, event);
                if (message == null) continue;
                this.broadcast(message);
            }
            catch (FrameworkException frameworkException) {}
        }
    }

    public void simpleBroadcast(String commandName, Map<String, Object> data, String exemptedSessionId) {
        this.broadcast(MessageBuilder.forName(commandName).data(data).build(), exemptedSessionId);
    }

    private WebSocketMessage getMessageForEvent(SecurityContext securityContext, ModificationEvent modificationEvent) throws FrameworkException {
        String callbackId = modificationEvent.getCallbackId();
        if (modificationEvent.isNode()) {
            NodeInterface node = (NodeInterface)modificationEvent.getGraphObject();
            if (modificationEvent.isDeleted()) {
                WebSocketMessage message = this.createMessage("DELETE", callbackId);
                message.setId((String)modificationEvent.getRemovedProperties().get((PropertyKey)GraphObject.id));
                message.setCode(200);
                return message;
            }
            if (modificationEvent.isCreated()) {
                WebSocketMessage message = this.createMessage("CREATE", callbackId);
                message.setGraphObject((GraphObject)node);
                message.setResult(Arrays.asList(node));
                message.setCode(201);
                return message;
            }
            if (modificationEvent.isModified()) {
                WebSocketMessage message = this.createMessage("UPDATE", callbackId);
                if (securityContext != null) {
                    String jsonName;
                    LinkedHashSet<String> propertySet = new LinkedHashSet<String>();
                    propertySet.add("id");
                    propertySet.add("type");
                    Iterator it = modificationEvent.getModifiedProperties().keySet().iterator();
                    while (it.hasNext()) {
                        jsonName = ((PropertyKey)it.next()).jsonName();
                        if (propertySet.contains(jsonName)) continue;
                        propertySet.add(jsonName);
                    }
                    it = modificationEvent.getRemovedProperties().keySet().iterator();
                    while (it.hasNext()) {
                        jsonName = ((PropertyKey)it.next()).jsonName();
                        if (propertySet.contains(jsonName)) continue;
                        propertySet.add(jsonName);
                    }
                    if (propertySet.size() > 2) {
                        securityContext.setCustomView(propertySet);
                    }
                }
                message.setGraphObject((GraphObject)node);
                message.setResult(Arrays.asList(node));
                message.setId(node.getUuid());
                message.getModifiedProperties().addAll(modificationEvent.getModifiedProperties().keySet());
                message.getRemovedProperties().addAll(modificationEvent.getRemovedProperties().keySet());
                message.setNodeData(modificationEvent.getData(securityContext));
                message.setCode(200);
                if (securityContext != null) {
                    securityContext.clearCustomView();
                }
                return message;
            }
        } else {
            RelationshipInterface relationship = (RelationshipInterface)modificationEvent.getGraphObject();
            RelationshipType relType = modificationEvent.getRelationshipType();
            if ("CONTAINS".equals(relType.name())) {
                if (modificationEvent.isDeleted()) {
                    WebSocketMessage message = this.createMessage("REMOVE_CHILD", callbackId);
                    message.setNodeData("parentId", relationship.getSourceNodeId());
                    message.setId(relationship.getTargetNodeId());
                    message.setCode(200);
                    return message;
                }
                if (modificationEvent.isCreated()) {
                    WebSocketMessage message = new WebSocketMessage();
                    NodeInterface startNode = relationship.getSourceNode();
                    NodeInterface endNode = relationship.getTargetNode();
                    if (startNode == null || endNode == null) {
                        return null;
                    }
                    message.setResult(Arrays.asList(endNode));
                    message.setId(endNode.getUuid());
                    message.setNodeData("parentId", startNode.getUuid());
                    message.setCode(200);
                    message.setCommand("APPEND_CHILD");
                    if (endNode instanceof DOMNode) {
                        Node refNode = ((DOMNode)endNode).getNextSibling();
                        if (refNode != null) {
                            message.setCommand("INSERT_BEFORE");
                            message.setNodeData("refId", ((AbstractNode)refNode).getUuid());
                        }
                    } else if (endNode instanceof User) {
                        message.setCommand("APPEND_USER");
                        message.setNodeData("refId", startNode.getUuid());
                    } else if (endNode instanceof AbstractFile) {
                        message.setCommand("APPEND_FILE");
                        message.setNodeData("refId", startNode.getUuid());
                    }
                    return message;
                }
            }
            if (modificationEvent.isDeleted()) {
                WebSocketMessage message = this.createMessage("DELETE", callbackId);
                message.setId((String)modificationEvent.getRemovedProperties().get((PropertyKey)GraphObject.id));
                message.setCode(200);
                return message;
            }
            if (modificationEvent.isModified()) {
                WebSocketMessage message = this.createMessage("UPDATE", callbackId);
                message.getModifiedProperties().addAll(modificationEvent.getModifiedProperties().keySet());
                message.getRemovedProperties().addAll(modificationEvent.getRemovedProperties().keySet());
                message.setNodeData(modificationEvent.getData(securityContext));
                message.setGraphObject((GraphObject)relationship);
                message.setId(relationship.getUuid());
                message.setCode(200);
                PropertyMap relProperties = relationship.getProperties();
                Map properties = PropertyMap.javaTypeToInputType((SecurityContext)securityContext, relationship.getClass(), (PropertyMap)relProperties);
                message.setRelData(properties);
                return message;
            }
        }
        return null;
    }

    private WebSocketMessage createMessage(String command, String callbackId) {
        WebSocketMessage newMessage = new WebSocketMessage();
        newMessage.setCommand(command);
        if (callbackId != null) {
            newMessage.setCallback(callbackId);
        }
        return newMessage;
    }
}

