/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class AppendFileCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)AppendFileCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        if (id == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node, no id is given").build(), true);
            return;
        }
        if (parentId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node without parentId").build(), true);
            return;
        }
        if (parentId.equals(id)) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node as its own child.").build(), true);
            return;
        }
        AbstractNode parentNode = this.getNode(parentId);
        if (parentNode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
            return;
        }
        if (parentNode instanceof Folder) {
            Folder folder = (Folder)parentNode;
            AbstractFile file = (AbstractFile)this.getNode(id);
            if (file != null) {
                try {
                    Folder currentParent = (Folder)file.treeGetParent();
                    if (currentParent != null) {
                        currentParent.treeRemoveChild(file);
                    }
                    folder.treeAppendChild(file);
                    TransactionCommand.registerNodeCallback((NodeInterface)file, (String)this.callback);
                }
                catch (FrameworkException ex) {
                    logger.error("", (Throwable)ex);
                    this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append file").build(), true);
                }
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Parent node is not instance of Folder").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "APPEND_FILE";
    }

    static {
        StructrWebSocket.addCommand(AppendFileCommand.class);
    }
}

