/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.autocomplete.AbstractHintProvider;
import org.structr.autocomplete.JavascriptHintProvider;
import org.structr.autocomplete.PlaintextHintProvider;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.Property;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.WebSocketMessage;

public class AutocompleteCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)AutocompleteCommand.class.getName());
    private static final Property<List<GraphObjectMap>> list = new GenericProperty("list");
    private static final Map<String, AbstractHintProvider> hintProviders = new HashMap<String, AbstractHintProvider>();

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> data = webSocketData.getNodeData();
        String id = webSocketData.getId();
        LinkedList<GraphObject> result = new LinkedList<GraphObject>();
        String contentType = this.getOrDefault(data.get("contentType"), "text/plain");
        if (contentType != null) {
            AbstractHintProvider hintProvider = hintProviders.get(contentType);
            if (hintProvider != null) {
                String currentToken = this.getAndTrim(data.get("currentToken"));
                String previousToken = this.getAndTrim(data.get("previousToken"));
                String thirdToken = this.getAndTrim(data.get("thirdToken"));
                String type = this.getAndTrim(data.get("type"));
                int cursorPosition = this.getInt(data.get("cursorPosition"));
                int line = this.getInt(data.get("line"));
                try {
                    List<GraphObject> hints = hintProvider.getHints(StructrApp.getInstance().get(id), type, currentToken, previousToken, thirdToken, line, cursorPosition);
                    result.addAll(hints);
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                }
            } else {
                logger.warn("No HintProvider for content type {}, ignoring.", (Object)contentType);
            }
        } else {
            logger.warn("No content type for AutocompleteCommand, ignoring.");
        }
        webSocketData.setResult(result);
        webSocketData.setRawResultCount(result.size());
        this.getWebSocket().send(webSocketData, true);
    }

    @Override
    public String getCommand() {
        return "AUTOCOMPLETE";
    }

    private String getAndTrim(Object source) {
        if (source != null && source instanceof String) {
            return ((String)source).trim();
        }
        return "";
    }

    private String getOrDefault(Object source, String defaultValue) {
        if (source != null && source instanceof String) {
            return ((String)source).trim();
        }
        return defaultValue;
    }

    private int getInt(Object source) {
        if (source != null) {
            if (source instanceof Number) {
                return ((Number)source).intValue();
            }
            if (source instanceof String) {
                try {
                    return Integer.parseInt(source.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    static {
        StructrWebSocket.addCommand(AutocompleteCommand.class);
        hintProviders.put("text/plain", new PlaintextHintProvider());
        hintProviders.put("text/javascript", new JavascriptHintProvider());
        hintProviders.put("application/javascript", new JavascriptHintProvider());
    }
}

