/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyMap;
import org.structr.util.Base64;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ChunkCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ChunkCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        try {
            FileBase file;
            int sequenceNumber = ((Long)webSocketData.getNodeData().get("chunkId")).intValue();
            int chunkSize = ((Long)webSocketData.getNodeData().get("chunkSize")).intValue();
            Object rawData = webSocketData.getNodeData().get("chunk");
            int chunks = ((Long)webSocketData.getNodeData().get("chunks")).intValue();
            String uuid = webSocketData.getId();
            byte[] data = new byte[]{};
            if (rawData != null && rawData instanceof String) {
                logger.debug("Raw data: {}", rawData);
                data = Base64.decode((String)((String)rawData));
                logger.debug("Decoded data: {}", (Object)data);
            }
            if (!(file = (FileBase)this.getNode(uuid)).isGranted(Permission.write, securityContext)) {
                logger.warn("No write permission for {} on {}", new Object[]{this.getWebSocket().getCurrentUser().toString(), file.toString()});
                this.getWebSocket().send(MessageBuilder.status().message("No write permission").code(400).build(), true);
                return;
            }
            this.getWebSocket().handleFileChunk(uuid, sequenceNumber, chunkSize, data, chunks);
            if (sequenceNumber + 1 == chunks) {
                long checksum = FileHelper.getChecksum(file);
                long size = FileHelper.getSize(file);
                PropertyMap changedProperties = new PropertyMap();
                changedProperties.put(FileBase.checksum, (Object)checksum);
                changedProperties.put(FileBase.size, (Object)size);
                file.unlockSystemPropertiesOnce();
                file.setProperties(securityContext, changedProperties);
                file.increaseVersion();
                this.getWebSocket().removeFileUploadHandler(uuid);
                logger.debug("File upload finished. Checksum: {}, size: {}", new Object[]{checksum, size});
            }
            long currentSize = (long)(sequenceNumber * chunkSize) + (long)data.length;
            this.getWebSocket().send(MessageBuilder.status().code(200).message("{\"id\":\"" + file.getUuid() + "\", \"name\":\"" + file.getName() + "\",\"size\":" + currentSize + "}").build(), true);
        }
        catch (IOException | FrameworkException ex) {
            String msg = ex.toString();
            this.getWebSocket().send(MessageBuilder.status().code(400).message("Could not process chunk data: ".concat(msg != null ? msg : "")).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CHUNK";
    }

    static {
        StructrWebSocket.addCommand(ChunkCommand.class);
    }
}

