/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class ClonePageCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ClonePageCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        block7: {
            SecurityContext securityContext = this.getWebSocket().getSecurityContext();
            String nodeId = webSocketData.getId();
            AbstractNode nodeToClone = this.getNode(nodeId);
            if (nodeToClone != null) {
                try {
                    Page pageToClone;
                    Page page = pageToClone = nodeToClone instanceof Page ? (Page)nodeToClone : null;
                    if (pageToClone == null) break block7;
                    Page newPage = (Page)pageToClone.cloneNode(false);
                    newPage.setProperties(securityContext, new PropertyMap((PropertyKey)Page.name, (Object)((String)pageToClone.getProperty((PropertyKey)Page.name) + "-" + newPage.getIdString())));
                    DOMNode firstChild = (DOMNode)pageToClone.getFirstChild().getNextSibling();
                    if (firstChild == null) {
                        firstChild = (DOMNode)pageToClone.treeGetFirstChild();
                    }
                    if (firstChild != null) {
                        DOMNode newHtmlNode = DOMNode.cloneAndAppendChildren(securityContext, firstChild);
                        newPage.appendChild(newHtmlNode);
                    }
                }
                catch (FrameworkException fex) {
                    logger.warn("Could not create node.", (Throwable)fex);
                    this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
                }
                catch (DOMException dex) {
                    logger.warn("Could not create node.", (Throwable)dex);
                    this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
                }
            } else {
                logger.warn("Node with uuid {} not found.", (Object)webSocketData.getId());
                this.getWebSocket().send(MessageBuilder.status().code(404).build(), true);
            }
        }
    }

    @Override
    public String getCommand() {
        return "CLONE_PAGE";
    }

    static {
        StructrWebSocket.addCommand(ClonePageCommand.class);
    }
}

