/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.schema.SchemaHelper;
import org.structr.web.entity.FileBase;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class CreateCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CreateCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        Map<String, Object> nodeData = webSocketData.getNodeData();
        try {
            PropertyMap properties = PropertyMap.inputTypeToJavaType((SecurityContext)securityContext, nodeData);
            Class type = SchemaHelper.getEntityClassForRawType((String)((String)properties.get((PropertyKey)AbstractNode.type)));
            NodeInterface newNode = app.create(type, properties);
            TransactionCommand.registerNodeCallback((NodeInterface)newNode, (String)this.callback);
            if (newNode instanceof FileBase) {
                Long size = (Long)webSocketData.getNodeData().get("size");
                String contentType = (String)webSocketData.getNodeData().get("contentType");
                String name = (String)webSocketData.getNodeData().get("name");
                FileBase fileNode = (FileBase)newNode;
                PropertyMap changedProperties = new PropertyMap();
                changedProperties.put((PropertyKey)File.size, (Object)(size != null ? size : 0L));
                changedProperties.put((PropertyKey)File.contentType, (Object)contentType);
                changedProperties.put((PropertyKey)AbstractNode.name, (Object)name);
                fileNode.setProperties(securityContext, changedProperties);
                this.getWebSocket().createFileUploadHandler(fileNode);
            }
        }
        catch (FrameworkException fex) {
            logger.warn("Could not create node.", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CREATE";
    }

    static {
        StructrWebSocket.addCommand(CreateCommand.class);
    }
}

