/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.command.ListUnattachedNodesCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class DeleteUnattachedNodesCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)DeleteUnattachedNodesCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) throws FrameworkException {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        LinkedList<Object> filteredResults = new LinkedList<Object>();
        try (Tx tx = app.tx(true, false, false);){
            List<AbstractNode> topNodes = ListUnattachedNodesCommand.getUnattachedNodes(app, securityContext, webSocketData);
            for (AbstractNode abstractNode : topNodes) {
                filteredResults.add(abstractNode);
                filteredResults.addAll(DOMNode.getAllChildNodes((DOMNode)abstractNode));
            }
            for (AbstractNode abstractNode : filteredResults) {
                app.delete((NodeInterface)abstractNode);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "DELETE_UNATTACHED_NODES";
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    static {
        StructrWebSocket.addCommand(DeleteUnattachedNodesCommand.class);
    }
}

