/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.web.entity.User;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class GetLocalStorageCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)GetLocalStorageCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        try {
            webSocketData.setNodeData("localStorageString", securityContext.getUser(false).getProperty(User.localStorage));
            this.getWebSocket().send(webSocketData, true);
        }
        catch (Throwable t) {
            logger.warn("Error retrieving localstorage", t);
            this.getWebSocket().send(MessageBuilder.status().code(422).message(t.toString()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "GET_LOCAL_STORAGE";
    }

    static {
        StructrWebSocket.addCommand(GetLocalStorageCommand.class);
    }
}

