/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class GetProperty
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        GraphObject obj = this.getGraphObject(webSocketData.getId());
        String key = (String)webSocketData.getNodeData().get("key");
        if (obj != null) {
            PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForJSONName(obj.getClass(), key);
            PropertyConverter converter = propertyKey.inputConverter(this.getWebSocket().getSecurityContext());
            Object value = obj.getProperty(propertyKey);
            if (converter != null) {
                try {
                    value = converter.revert(value);
                }
                catch (FrameworkException ex) {
                    this.getWebSocket().send(MessageBuilder.status().code(400).message(ex.getMessage()).build(), true);
                }
            }
            webSocketData.setNodeData(key, value);
            this.getWebSocket().send(webSocketData, true);
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(404).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "GET_PROPERTY";
    }

    static {
        StructrWebSocket.addCommand(GetProperty.class);
    }
}

