/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.Property;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class LayoutsCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)LayoutsCommand.class.getName());
    private static final Property<List<String>> layoutsProperty = new GenericProperty("layouts");

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        block22: {
            block21: {
                Map<String, Object> data = webSocketData.getNodeData();
                String mode = (String)data.get("mode");
                String name = (String)data.get("name");
                if (mode == null) break block21;
                LinkedList<GraphObjectMap> result = new LinkedList<GraphObjectMap>();
                switch (mode) {
                    case "list": {
                        List<String> layouts = LayoutsCommand.listLayouts();
                        if (layouts != null) {
                            GraphObjectMap layoutContainer = new GraphObjectMap();
                            layoutContainer.put(layoutsProperty, layouts);
                            result.add(layoutContainer);
                            webSocketData.setResult(result);
                            webSocketData.setRawResultCount(1);
                            this.getWebSocket().send(webSocketData, true);
                            break;
                        }
                        break block22;
                    }
                    case "get": {
                        try {
                            String content = new String(Files.readAllBytes(LayoutsCommand.locateFile(name).toPath()));
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).data("schemaLayout", content).build(), true);
                        }
                        catch (IOException | FrameworkException ex) {
                            logger.error("", ex);
                        }
                        break;
                    }
                    case "add": {
                        String positions = (String)data.get("schemaLayout");
                        try {
                            File layoutFile = LayoutsCommand.locateFile(name);
                            if (layoutFile.exists()) {
                                this.getWebSocket().send(MessageBuilder.status().code(422).message("Layout already exists!").build(), true);
                            } else {
                                this.createLayout(name, positions);
                            }
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).build(), true);
                        }
                        catch (FrameworkException ex) {
                            logger.error("", (Throwable)ex);
                        }
                        break;
                    }
                    case "delete": {
                        try {
                            this.deleteLayout(name);
                            this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).build(), true);
                        }
                        catch (FrameworkException ex) {
                            logger.error("", (Throwable)ex);
                        }
                        break;
                    }
                    default: {
                        this.getWebSocket().send(MessageBuilder.status().code(422).message("Mode must be one of list, get, add or delete.").build(), true);
                        break;
                    }
                }
                break block22;
            }
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Mode must be one of list, get, add or delete.").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "LAYOUTS";
    }

    private void createLayout(String name, String positions) throws FrameworkException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            File layoutFile = LayoutsCommand.locateFile(name);
            try (FileWriter writer = new FileWriter(layoutFile);){
                ((Writer)writer).append(positions);
                ((Writer)writer).append("\n");
                ((Writer)writer).flush();
            }
            tx.success();
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void deleteLayout(String fileName) throws FrameworkException {
        if (fileName == null) {
            throw new FrameworkException(422, "Please supply schema name to import.");
        }
        File layoutFile = LayoutsCommand.locateFile(fileName);
        layoutFile.delete();
    }

    public static List<String> listLayouts() {
        String[] names;
        File baseDir = new File(LayoutsCommand.getLayoutsPath());
        LinkedList<String> fileNames = new LinkedList<String>();
        if (baseDir.exists() && (names = baseDir.list((dir, name) -> name.endsWith(".json"))) != null) {
            fileNames.addAll(Arrays.asList(names));
        }
        Collections.sort(fileNames, String.CASE_INSENSITIVE_ORDER);
        return fileNames;
    }

    public static File locateFile(String name) throws FrameworkException {
        File path;
        File parent;
        String fileName = name;
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "layout.json";
        }
        if (File.separator.equals("/") && fileName.contains(File.separator) || File.separator.equals("\\") && (fileName.contains("/") || fileName.contains("\\"))) {
            throw new FrameworkException(422, "Only relative file names are allowed, please use the " + Settings.SnapshotsPath.getKey() + " configuration setting to supply a custom path for snapshots.");
        }
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(parent = (path = new File(LayoutsCommand.getLayoutsPath() + fileName)).getParentFile()).exists()) {
            parent.mkdirs();
        }
        return path;
    }

    public static String getLayoutsPath() {
        return Settings.getFullSettingPath((Setting)Settings.LayoutsPath);
    }

    static {
        StructrWebSocket.addCommand(LayoutsCommand.class);
    }
}

