/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.structr.web.entity.html.Input;
import org.structr.web.entity.html.Link;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ListActiveElementsCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ListActiveElementsCommand.class.getName());
    private static final Property<Integer> recursionDepthProperty = new IntProperty("recursionDepth");
    private static final Property<String> parentIdProperty = new StringProperty("parentId");
    private static final Property<String> stateProperty = new StringProperty("state");
    private static final Property<String> actionProperty = new StringProperty("action");
    private static final Property<String> queryProperty = new StringProperty("query");

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        String id = webSocketData.getId();
        try (Tx tx = app.tx();){
            Page page = (Page)app.get(Page.class, id);
            LinkedList<GraphObject> result = new LinkedList<GraphObject>();
            if (page != null) {
                this.collectActiveElements(result, page, Collections.EMPTY_SET, null, 0);
                webSocketData.setResult(result);
                webSocketData.setRawResultCount(result.size());
                this.getWebSocket().send(webSocketData, true);
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Page with ID " + id + " not found.").build(), true);
            }
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "LIST_ACTIVE_ELEMENTS";
    }

    private void collectActiveElements(List<GraphObject> resultList, DOMNode root, Set<String> parentDataKeys, String parent, int depth) {
        ActiveElementState state;
        String childDataKey = (String)root.getProperty((PropertyKey)DOMElement.dataKey);
        LinkedHashSet<String> dataKeys = new LinkedHashSet<String>(parentDataKeys);
        String parentId = parent;
        int dataCentricDepth = depth;
        if (!StringUtils.isEmpty((CharSequence)childDataKey)) {
            dataKeys.add(childDataKey);
            ++dataCentricDepth;
        }
        if (!(state = this.isActive(root, dataKeys)).equals((Object)ActiveElementState.None)) {
            resultList.add(this.extractActiveElement(root, dataKeys, parentId, state, depth));
            if (state.equals((Object)ActiveElementState.Query)) {
                parentId = root.getUuid();
            }
        }
        for (DOMChildren children : root.getChildRelationships()) {
            DOMNode child = (DOMNode)children.getTargetNode();
            this.collectActiveElements(resultList, child, dataKeys, parentId, dataCentricDepth);
        }
    }

    private GraphObject extractActiveElement(DOMNode node, Set<String> dataKeys, String parentId, ActiveElementState state, int depth) {
        GraphObjectMap activeElement = new GraphObjectMap();
        activeElement.put((PropertyKey)GraphObject.id, (Object)node.getUuid());
        activeElement.put((PropertyKey)GraphObject.type, (Object)node.getType());
        activeElement.put((PropertyKey)DOMElement.dataKey, (Object)StringUtils.join(dataKeys, (String)","));
        activeElement.put(Content.content, node.getProperty((PropertyKey)Content.content));
        switch (state) {
            case Button: {
                activeElement.put(actionProperty, node.getProperty((PropertyKey)DOMElement._action));
                break;
            }
            case Link: {
                activeElement.put(actionProperty, node.getProperty((PropertyKey)Link._href));
                break;
            }
            case Query: {
                this.extractQueries(activeElement, node);
            }
        }
        activeElement.put(stateProperty, (Object)state.name());
        activeElement.put(recursionDepthProperty, (Object)depth);
        activeElement.put(parentIdProperty, (Object)parentId);
        return activeElement;
    }

    private ActiveElementState isActive(DOMNode node, Set<String> dataKeys) {
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)DOMElement.dataKey)))) {
            return ActiveElementState.Query;
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)DOMElement.restQuery)))) {
            return ActiveElementState.Query;
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)DOMElement.cypherQuery)))) {
            return ActiveElementState.Query;
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)DOMElement.xpathQuery)))) {
            return ActiveElementState.Query;
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)DOMElement.functionQuery)))) {
            return ActiveElementState.Query;
        }
        if (node.getProperty((PropertyKey)DOMElement._action) != null || node.getProperty((PropertyKey)DOMElement._attributes) != null || node.getProperty((PropertyKey)DOMElement._rawValue) != null) {
            return ActiveElementState.Button;
        }
        if (node.getProperty((PropertyKey)Content.content) != null && !dataKeys.isEmpty() && this.containsDataKeyReference((String)node.getProperty((PropertyKey)Content.content), dataKeys)) {
            return ActiveElementState.Content;
        }
        if (node.getProperty((PropertyKey)DOMElement._id) != null && !dataKeys.isEmpty() && this.containsDataKeyReference((String)node.getProperty((PropertyKey)DOMElement._id), dataKeys)) {
            return ActiveElementState.Content;
        }
        if (node.getProperty((PropertyKey)Link._href) != null && !dataKeys.isEmpty() && this.containsDataKeyReference((String)node.getProperty((PropertyKey)Link._href), dataKeys)) {
            return ActiveElementState.Link;
        }
        if (node.getProperty((PropertyKey)Input._value) != null && !dataKeys.isEmpty() && this.containsDataKeyReference((String)node.getProperty((PropertyKey)Input._value), dataKeys)) {
            return ActiveElementState.Input;
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)DOMNode.hideConditions)))) {
            return ActiveElementState.Hidden;
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)DOMNode.showConditions)))) {
            return ActiveElementState.Hidden;
        }
        if (((Boolean)node.getProperty((PropertyKey)DOMNode.hideOnIndex)).booleanValue()) {
            return ActiveElementState.Hidden;
        }
        if (((Boolean)node.getProperty((PropertyKey)DOMNode.hideOnDetail)).booleanValue()) {
            return ActiveElementState.Hidden;
        }
        return ActiveElementState.None;
    }

    private boolean containsDataKeyReference(String value, Set<String> dataKeys) {
        boolean contains = false;
        for (String dataKey : dataKeys) {
            contains |= value.contains(dataKey);
        }
        return contains;
    }

    private void extractQueries(GraphObjectMap activeElement, DOMNode node) {
        if (this.extractQuery(activeElement, node, (Property<String>)DOMElement.restQuery)) {
            return;
        }
        if (this.extractQuery(activeElement, node, (Property<String>)DOMElement.cypherQuery)) {
            return;
        }
        if (this.extractQuery(activeElement, node, (Property<String>)DOMElement.xpathQuery)) {
            return;
        }
    }

    private boolean extractQuery(GraphObjectMap activeElement, DOMNode node, Property<String> queryKey) {
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)node.getProperty((PropertyKey)queryKey)))) {
            activeElement.put(queryProperty, node.getProperty((PropertyKey)queryKey));
            return true;
        }
        return false;
    }

    static {
        StructrWebSocket.addCommand(ListActiveElementsCommand.class);
    }

    public static enum ActiveElementState {
        None,
        Query,
        Content,
        Input,
        Button,
        Link,
        Hidden;

    }
}

