/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.LinkedList;
import java.util.Set;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.GenericNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.schema.ConfigurationProvider;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ListSchemaPropertiesCommand
extends AbstractCommand {
    private static final Property<Boolean> isSelected = new BooleanProperty("isSelected");
    private static final Property<Boolean> isDisabled = new BooleanProperty("isDisabled");

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String view = (String)webSocketData.getNodeData().get("view");
        String id = webSocketData.getId();
        LinkedList<GraphObjectMap> result = new LinkedList<GraphObjectMap>();
        if (view != null) {
            if (id != null) {
                AbstractNode schemaObject = this.getNode(id);
                if (schemaObject != null) {
                    Class type;
                    ConfigurationProvider config = StructrApp.getConfiguration();
                    String typeName = (String)schemaObject.getProperty((PropertyKey)AbstractNode.name);
                    if (typeName == null && schemaObject instanceof SchemaRelationshipNode) {
                        typeName = ((SchemaRelationshipNode)schemaObject).getClassName();
                    }
                    if ((type = config.getNodeEntityClass(typeName)) == null || GenericNode.class.equals((Object)type)) {
                        type = config.getRelationshipEntityClass(typeName);
                    }
                    if (type != null) {
                        Set allProperties = config.getPropertySet(type, "all");
                        Set viewProperties = config.getPropertySet(type, view);
                        Set parentProperties = config.getPropertySet(type.getSuperclass(), view);
                        for (PropertyKey key : allProperties) {
                            String declaringClass = key.getDeclaringClass() != null ? key.getDeclaringClass().getSimpleName() : "GraphObject";
                            String propertyName = key.jsonName();
                            GraphObjectMap property = new GraphObjectMap();
                            Class valueType = key.valueType();
                            String valueTypeName = "Unknown";
                            boolean _isDisabled = false;
                            if (valueType != null) {
                                valueTypeName = valueType.getSimpleName();
                            }
                            if (parentProperties.contains(key)) {
                                _isDisabled = true;
                            }
                            property.put((PropertyKey)AbstractNode.name, (Object)propertyName);
                            property.put(isSelected, (Object)viewProperties.contains(key));
                            property.put(isDisabled, (Object)_isDisabled);
                            property.put((PropertyKey)SchemaProperty.propertyType, (Object)valueTypeName);
                            property.put((PropertyKey)SchemaProperty.notNull, (Object)key.isNotNull());
                            property.put((PropertyKey)SchemaProperty.unique, (Object)key.isUnique());
                            property.put((PropertyKey)SchemaProperty.isDynamic, (Object)key.isDynamic());
                            property.put((PropertyKey)SchemaProperty.declaringClass, (Object)declaringClass);
                            result.add(property);
                        }
                    } else {
                        this.getWebSocket().send(MessageBuilder.status().code(404).message("Type " + typeName + " not found.").build(), true);
                    }
                } else {
                    this.getWebSocket().send(MessageBuilder.status().code(404).message("Schema node with ID " + id + " not found.").build(), true);
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("LIST_SCHEMA_PROPERTIES needs an ID.").build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("LIST_SCHEMA_PROPERTIES needs a view name in nodeData.").build(), true);
        }
        webSocketData.setView("ui");
        webSocketData.setResult(result);
        webSocketData.setRawResultCount(1);
        this.getWebSocket().send(webSocketData, true);
    }

    @Override
    public String getCommand() {
        return "LIST_SCHEMA_PROPERTIES";
    }

    static {
        StructrWebSocket.addCommand(ListSchemaPropertiesCommand.class);
    }
}

