/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.Template;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ListUnattachedNodesCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ListUnattachedNodesCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        int pageSize = webSocketData.getPageSize();
        int page = webSocketData.getPage();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        try (Tx tx = app.tx();){
            List<AbstractNode> filteredResults = ListUnattachedNodesCommand.getUnattachedNodes(app, securityContext, webSocketData);
            int resultCountBeforePaging = filteredResults.size();
            webSocketData.setResult(PagingHelper.subList(filteredResults, (int)pageSize, (int)page, null));
            webSocketData.setRawResultCount(resultCountBeforePaging);
            this.getWebSocket().send(webSocketData, true);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    protected static List<AbstractNode> getUnattachedNodes(App app, SecurityContext securityContext, WebSocketMessage webSocketData) throws FrameworkException {
        String sortOrder = webSocketData.getSortOrder();
        String sortKey = webSocketData.getSortKey();
        PropertyKey sortProperty = StructrApp.getConfiguration().getPropertyKeyForJSONName(DOMNode.class, sortKey);
        Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery().includeDeletedAndHidden().sort(sortProperty).order("desc".equals(sortOrder));
        query.orTypes(DOMElement.class);
        query.orType(Content.class);
        query.orType(Template.class);
        LinkedList<AbstractNode> filteredResults = new LinkedList<AbstractNode>();
        List resultList = null;
        try (Tx tx = app.tx();){
            resultList = query.getAsList();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
        }
        if (resultList != null) {
            for (GraphObject obj : resultList) {
                AbstractNode node;
                if (!(obj instanceof AbstractNode) || (node = (AbstractNode)obj).hasIncomingRelationships(DOMChildren.class) || node.getProperty(DOMNode.ownerDocument) != null || node instanceof ShadowDocument) continue;
                filteredResults.add(node);
            }
        }
        return filteredResults;
    }

    @Override
    public String getCommand() {
        return "LIST_UNATTACHED_NODES";
    }

    static {
        StructrWebSocket.addCommand(ListUnattachedNodesCommand.class);
    }
}

