/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.LinkedList;
import java.util.Map;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.Content;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class PatchCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)PatchCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        AbstractNode node = this.getNode(webSocketData.getId());
        Map<String, Object> properties = webSocketData.getNodeData();
        String patch = (String)properties.get("patch");
        if (node != null) {
            DiffMatchPatch dmp = new DiffMatchPatch();
            String oldText = (String)node.getProperty(Content.content);
            LinkedList patches = new LinkedList(dmp.patchFromText(patch));
            Object[] results = dmp.patchApply(patches, oldText);
            try {
                node.setProperties(node.getSecurityContext(), new PropertyMap(Content.content, (Object)results[0].toString()));
                TransactionCommand.registerNodeCallback((NodeInterface)node, (String)this.callback);
            }
            catch (Throwable t) {
                logger.warn("Could not apply patch {}", (Object)patch);
                this.getWebSocket().send(MessageBuilder.status().code(400).message("Could not apply patch. " + t.getMessage()).build(), true);
            }
        } else {
            logger.warn("Node with uuid {} not found.", (Object)webSocketData.getId());
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Node with uuid " + webSocketData.getId() + " not found.").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "PATCH";
    }

    static {
        StructrWebSocket.addCommand(PatchCommand.class);
    }
}

